﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

public class MagnetView : MonoBehaviour
{
    [Header("跳跃速度")]
    public float m_spaceSpeed = 0.0f;

    [Header("移动速度")]
    public float m_moveSpeed = 0.0f;
    [Header("是否开启磁场效果")]
    public bool m_isOpen = false;
    [Header("磁场范围")]
    [Range(0, 20)]
    public float m_range = 0.0f;
    [Header("磁场强度")]
    public float m_power = 0.0f;
    [Header("子弹被吸附距离")]
    public float m_disBulletAttach = 0.0f;
    [Header("相机与人物距离")]
    public Vector3 offset; //游戏人物与 相机的差
    [Header("南极图标")]
    public GameObject m_southObj;//南极obj
    [Header("北极图标")]
    public GameObject m_northObj;//北极obj
    [Header("南极材质")]
    public Material m_southMat;
    [Header("北极材质")]
    public Material m_northMat;
    public MeshRenderer[] m_poleMR;//mesh
    public float magnetRange => m_range;
    public float magnetPower => m_power;
    public float disBulletAttach => m_disBulletAttach;
    public bool isOpen => m_isOpen;
    private bool m_bSouthPole = true;//默认南极
    public bool isSouthPole => m_bSouthPole;
    private Rigidbody m_rigidBody;//刚体
    // Start is called before the first frame update
    void Start()
    {
        m_rigidBody = GetComponent<Rigidbody>();
        string varLevelKey = BattleCtrl.instance.levelManager.CurLevelIndex.ToString();
        if (LocalRecord.HasKey(varLevelKey))
        {
            string varValue = LocalRecord.GetStringRecord(varLevelKey);
            Vector3 varPos = Vector3.zero;
            varPos.x = Convert.ToSingle(varValue.Split('*')[0]);
            varPos.y = Convert.ToSingle(varValue.Split('*')[1]);
            varPos.z = Convert.ToSingle(varValue.Split('*')[2]);
            transform.position = varPos;
        }
    }
    //碰到子弹
    private void OnCollisionEnter(Collision other)
    {
        if (other.collider.CompareTag("Bullet"))
        {
            BulletSouthView varSouth = other.collider.GetComponent<BulletSouthView>();
            if (varSouth)
            {
                BattleCtrl.instance.battleUI.ReduceBlood(1);
                varSouth.SetActiveState(false);
            }
            BulletNorthView varNorth = other.collider.GetComponent<BulletNorthView>();
            if (varNorth)
            {
                BattleCtrl.instance.battleUI.ReduceBlood(1);
                varNorth.SetActiveState(false);
            }
            //做法1
            //BulletDamageView varBullet = other.collider.GetComponent<BulletDamageView>();
            //if (varBullet)
            //{
            //    BattleCtrl.instance.battleUI.ReduceBlood(1);
            //    varBullet.SetActiveState(false);
            //}
        }
    }
    //受磁铁作用力
    public void AddForce(Vector3 force)
    {
        m_rigidBody.AddForce(force, ForceMode.Impulse);
    }

    // Update is called once per frame
    void Update()
    {
        if(BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        float KeyVertical = 0.0f;
        float KeyHorizontal = 0.0f;
        if (Input.GetKey(KeyCode.W))
        {
            KeyVertical = Input.GetAxis("Vertical");
            transform.Translate(transform.forward * m_moveSpeed * Time.deltaTime, Space.World);
        }
        else if (Input.GetKey(KeyCode.S))
        {
            KeyVertical = Input.GetAxis("Vertical");
            transform.Translate(transform.forward * m_moveSpeed * Time.deltaTime, Space.World);
        }

        if (Input.GetKey(KeyCode.A))
        {
            KeyHorizontal = Input.GetAxis("Horizontal");
            transform.Translate(transform.forward * m_moveSpeed * Time.deltaTime, Space.World);
        }
        else if (Input.GetKey(KeyCode.D))
        {
            KeyHorizontal = Input.GetAxis("Horizontal");
            transform.Translate(transform.forward * m_moveSpeed * Time.deltaTime, Space.World);
        }
        if (Input.GetKey(KeyCode.Space))
        {
            transform.Translate(transform.up * m_spaceSpeed * Time.deltaTime, Space.World);
        }
        //获取控制的方向， 上下左右， 
        if(KeyVertical != 0.0f || KeyHorizontal != 0.0f)
        {
            Vector3 newDir = new Vector3(KeyHorizontal, 0, KeyVertical).normalized;
            transform.forward = Vector3.Lerp(transform.forward, newDir, 0.8f);
        }
        //镜头跟随
        Camera.main.transform.position = transform.position + offset;
        ChangeMagnetPole();
        UpdateUIBloodPos();
    }
    //鼠标左键变换磁极
    void ChangeMagnetPole()
    {
        if(Input.GetMouseButtonUp(0))
        {
            m_bSouthPole = !m_bSouthPole;
            for(int i = 0;i<m_poleMR.Length;i++)
            {
                m_poleMR[i].sharedMaterial = m_bSouthPole ? m_southMat : m_northMat;
            }
            m_southObj.SetActive(m_bSouthPole);
            m_northObj.SetActive(!m_bSouthPole);
        }
    }
    //更新UI血量位置
    void UpdateUIBloodPos()
    {
        Vector3 varVec3 = Camera.main.WorldToScreenPoint(transform.position);
        varVec3.x = (varVec3.x - Screen.width / 2f) / (Screen.height / GlobalConfig.NormalHeight);
        varVec3.y = (varVec3.y - Screen.height / 2f) / (Screen.height / GlobalConfig.NormalHeight)+150.0f;
        BattleCtrl.instance.battleUI.SetBloodPos(varVec3.x, varVec3.y);
    }
}
