﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class LargeMagnetView : MonoBehaviour
{
    //[Header("是否开启")]
    //public bool m_isOpen = false;
    //[Header("磁场范围")]
    //[Range(0, 20)]
    //public float m_range = 0.0f;
    //[Header("磁场强度")]
    //public float m_power = 0.0f;
    [Header("磁极")]
    public PoleType m_poleType = PoleType.PT_South;
    [Header("是否变换磁极")]
    public bool m_bIsChangePole = false;
    [Header("循环间隔")]
    public float m_changePoleLoopTime = 0.0f;
    [Header("磁极自动转换列表")]
    public List<int> m_poleList;
    [Header("是否生成机关")]
    public bool m_bIsTrigger = false;
    [Header("生成机关位置")]
    public Vector3 m_triggerPos = Vector3.zero;
    [Header("南极图标")]
    public GameObject m_southObj;//南极obj
    [Header("北极图标")]
    public GameObject m_northObj;//北极obj
    [Header("南极材质")]
    public Material m_southMat;
    [Header("北极材质")]
    public Material m_northMat;
    [Header("无磁极材质")]
    public Material m_noPoleMat;
    public MeshRenderer[] m_poleMR;//mesh

    private bool m_bControlCollison = true;
    private GameObject m_triggerObj;//机关
    //private bool m_bSouthPole = true;//默认南极
    //private int m_curPole = GlobalConfig.SouthPole;//默认南极
    private bool m_bAddPower = false;//增加磁力
    private bool m_bTrap = false;//设置陷阱
    private TrapView m_trapView;//陷阱脚本
    private MoveView m_moveView;//移动触发器
    private Rigidbody m_rigidBody;
    private bool m_bControlPole = true;
    private string m_strSetMagnetChangeLoop = "SetMagnetChangeLoop";
    private int m_curChangeIndex = 0;
    // Update is called once per frame
    private void Start()
    {
        m_rigidBody = GetComponent<Rigidbody>();
    }
    private void OnCollisionEnter(Collision other)
    {
        if(other.collider.CompareTag("Player") && m_bControlCollison)
        {
            m_bControlCollison = false;
            m_trapView = GetComponent<TrapView>();
            if (m_trapView && m_trapView.enabled)
            {
                BattleCtrl.instance.battleUI.ReduceBlood(m_trapView.damage);
            }
        }
    }
    private void OnCollisionExit(Collision other)
    {
        if (other.collider.CompareTag("Player") && !m_bControlCollison)
        {
            m_bControlCollison = true;
        }
    }
    //设置机关状态
    public void SetTriggerActive(bool value)
    {
        if(m_triggerObj)
        {
            m_triggerObj.SetActive(value);
        }
    }
    //设置磁极变换
    public void SetMagnetChange()
    {
        m_bIsChangePole = true;
        //m_bSouthPole = !m_bSouthPole;
        //for (int i = 0; i < m_poleMR.Length; i++)
        //{
        //    m_poleMR[i].sharedMaterial = m_bSouthPole ? m_southMat : m_northMat;
        //}
        //m_southObj.SetActive(m_bSouthPole);
        //m_northObj.SetActive(!m_bSouthPole);
    }    
    //磁极转换循环
    void SetMagnetChangeLoop()
    {
        if(m_poleList[m_curChangeIndex] == GlobalConfig.PT_South)
        {
            m_poleType = PoleType.PT_South;
        }
        else if(m_poleList[m_curChangeIndex] == GlobalConfig.PT_North)
        {
            m_poleType = PoleType.PT_North;
        }
        else
        {
            m_poleType = PoleType.PT_No;
        }
        m_curChangeIndex++;
        if(m_curChangeIndex >= m_poleList.Count)
        {
            m_curChangeIndex = 0;
        }
    }
    //材质变换
    void UpdateMatState()
    {
        for (int i = 0; i < m_poleMR.Length; i++)
        {
            if (m_poleType == PoleType.PT_South)
            {
                m_poleMR[i].sharedMaterial = m_southMat;
            }
            else if (m_poleType == PoleType.PT_North)
            {
                m_poleMR[i].sharedMaterial = m_northMat;
            }
            else
            {
                m_poleMR[i].sharedMaterial = m_noPoleMat;
            }
        }
        m_southObj.SetActive(m_poleType == PoleType.PT_South);
        m_northObj.SetActive(m_poleType == PoleType.PT_North);
    }
    //设置磁力变化
    public void SetMagnetPower(float addPower)
    {
        //m_bAddPower = !m_bAddPower;
        //if(m_bAddPower)
        //{
        //    m_power += addPower;
        //}
        //else
        //{
        //    m_power -= addPower;
        //}
    }
    //设置陷阱状态
    public void SetTrap()
    {
        m_bTrap = !m_bTrap;
        if (m_bTrap)
        {
            if(!m_trapView)
            {
                m_trapView = gameObject.AddComponent<TrapView>();
            }
        }
        if (m_trapView)
        {
            m_trapView.enabled = m_bTrap;
        }
    }
    //设置移动触发器
    public void SetMove()
    {
        if (!m_moveView)
        {
            m_moveView = gameObject.AddComponent<MoveView>();
        }
    }
    void Update()
    {
        MagnetView varPlayer = BattleCtrl.instance.levelManager.curLevel.magnetView;
        if (varPlayer.isOpen)
        {
            Vector3 varDir = transform.position - varPlayer.transform.position;
            if (varPlayer && Vector3.SqrMagnitude(varDir) <= varPlayer .magnetRange* varPlayer.magnetRange)
            {
                if(varPlayer.isSouthPole)
                {
                    if (m_poleType == PoleType.PT_South)
                    {
                        m_rigidBody.AddForce(varDir.normalized * varPlayer.magnetPower, ForceMode.Impulse);
                    }
                    else if (m_poleType == PoleType.PT_North)
                    {
                        m_rigidBody.AddForce(-varDir.normalized * varPlayer.magnetPower, ForceMode.Impulse);
                    }
                }
                else
                {
                    if (m_poleType == PoleType.PT_South)
                    {
                        m_rigidBody.AddForce(-varDir.normalized * varPlayer.magnetPower, ForceMode.Impulse);
                    }
                    else if (m_poleType == PoleType.PT_North)
                    {
                        m_rigidBody.AddForce(varDir.normalized * varPlayer.magnetPower, ForceMode.Impulse);
                    }
                }
            }
        }
        if(m_bIsTrigger)
        {
            if (!m_triggerObj)
            {
                m_triggerObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.triggerObj);
                m_triggerObj.transform.position = m_triggerPos;
                m_triggerObj.GetComponent<TriggerView>().SetLargeAttach(this);
            }
        }
        //磁极变换
        if (m_bIsChangePole)
        {
            if(m_bControlPole)
            {
                m_bControlPole = false;
                InvokeRepeating(m_strSetMagnetChangeLoop, 0.2f, m_changePoleLoopTime);
            }
        }
        else
        {
            m_bControlPole = true;
            CancelInvokeMagnetChange();
        }
        UpdateMatState();
    }
    //取消循环
    void CancelInvokeMagnetChange()
    {
        if (IsInvoking(m_strSetMagnetChangeLoop))
        {
            CancelInvoke(m_strSetMagnetChangeLoop);
        }
    }
    private void OnDestroy()
    {
        CancelInvokeMagnetChange();
    }
}
