﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class BossView : MonoBehaviour
{
    //[Header("子弹父节点")]
    //public Transform m_parent;
    //[Header("旋转速度")]
    //public float m_rotateSpeed = 0.0f;
    [Header("过多久发射子弹")]
    public float m_waitTime = 0.0f;
    [Header("发射子弹间隔时间")]
    public float m_intervalTime = 0.0f;
    [Header("是否移动")]
    public bool m_isMove = false;
    [Header("移动速度")]
    public float m_moveSpeed = 0.0f;

    private Animator m_animator;
    //private Transform[] m_bulletTrans;
    private float m_time = 0.0f;
    private bool m_bControl = false;
    private int m_index = 1;
    //private List<Vector3> m_startPosList = new List<Vector3>();//初始位置
    private Vector3 m_movePointA;
    private Vector3 m_movePointB;
    private bool m_bIsForWard = true;//是否正向运动，开始默认正向
    private bool m_bIsDie = false;//是否死亡
    private GameObject m_curBulletObj;//当前子弹
    // Start is called before the first frame update
    void Start()
    {
        m_animator = GetComponent<Animator>();
        m_animator.Play("Idle");
        m_movePointA = new Vector3(transform.position.x, transform.position.y, 3);
        m_movePointB = new Vector3(transform.position.x, transform.position.y, -3);
        //做法1
        //m_animator = GetComponent<Animator>();
        //m_animator.Play("Run");
        //m_bulletTrans = m_parent.GetComponentsInChildren<Transform>();
        //for (int i = 1; i < m_bulletTrans.Length; i++)
        //{
        //    m_startPosList.Add(m_bulletTrans[i].localPosition);
        //}
        //m_movePointA = new Vector3(transform.position.x, transform.position.y, 3);
        //m_movePointB = new Vector3(transform.position.x, transform.position.y, -3);
    }
    //死亡
    public void Die()
    {
        m_bIsDie = true;
        m_animator.Play("Die");
    }
    //重置状态
    public void ResetState()
    {
        m_bIsDie = false;
        m_animator.Play("Idle");
        m_time = 0.0f;
        m_index = 1;
        m_bControl = false;
        CancelInvokeBullet();
        //做法1
        //m_bIsDie = false;
        //m_animator.Play("Run");
        //m_time = 0.0f;
        //m_index = 1;
        //m_bControl = false;
        //CancelInvokeBullet();
        //for (int i = 1; i < m_bulletTrans.Length; i++)
        //{
        //    BulletDamageView varDamage = m_bulletTrans[i].GetComponent<BulletDamageView>();
        //    if (varDamage)
        //    {
        //        varDamage.ResetState();
        //    }
        //    BulletSouthView varSouth = m_bulletTrans[i].GetComponent<BulletSouthView>();
        //    if (varSouth)
        //    {
        //        varSouth.ResetState();
        //    }
        //    BulletNorthView varNorth = m_bulletTrans[i].GetComponent<BulletNorthView>();
        //    if (varNorth)
        //    {
        //        varNorth.ResetState();
        //    }
        //    m_bulletTrans[i].localPosition = m_startPosList[i - 1];
        //}
    }
    //碰到子弹
    private void OnCollisionEnter(Collision other)
    {
        if (other.collider.CompareTag("Bullet"))
        {
            BulletNorthView varNorthBullet = other.collider.GetComponent<BulletNorthView>();
            if (varNorthBullet)
            {
                BattleCtrl.instance.battleUI.ReduceBossBlood();
                varNorthBullet.SetActiveState(false);
            }
            BulletSouthView varSouthBullet = other.collider.GetComponent<BulletSouthView>();
            if (varSouthBullet)
            {
                BattleCtrl.instance.battleUI.ReduceBossBlood();
                varSouthBullet.SetActiveState(false);
            }
        }
        if (other.collider.CompareTag("Player"))
        {
            TrapView varTrapView = GetComponent<TrapView>();
            if (varTrapView && varTrapView.enabled)
            {
                BattleCtrl.instance.battleUI.ReduceBlood(varTrapView.damage);
            }
        }
        //做法1
        //if (other.collider.CompareTag("Bullet"))
        //{
        //    BulletNorthView varNorthBullet = other.collider.GetComponent<BulletNorthView>();
        //    if (varNorthBullet)
        //    {
        //        BattleCtrl.instance.battleUI.ReduceBossBlood();
        //        varNorthBullet.SetActiveState(false);
        //    }
        //    BulletSouthView varSouthBullet = other.collider.GetComponent<BulletSouthView>();
        //    if (varSouthBullet)
        //    {
        //        BattleCtrl.instance.battleUI.ReduceBossBlood();
        //        varSouthBullet.SetActiveState(false);
        //    }
        //}
        //if (other.collider.CompareTag("Player"))
        //{
        //    TrapView varTrapView = GetComponent<TrapView>();
        //    if (varTrapView && varTrapView.enabled)
        //    {
        //        BattleCtrl.instance.battleUI.ReduceBlood(1);
        //    }
        //}
    }
    // Update is called once per frame
    void Update()
    {
        m_time += Time.deltaTime;
        if (m_time >= m_waitTime && !m_bControl)
        {
            m_bControl = true;
            InvokeRepeating("SendBullet", 0.0f, m_intervalTime);
        }
        //做法1
        //m_time += Time.deltaTime;
        //if(m_time >= m_waitTime && !m_bControl)
        //{
        //    m_bControl = true;
        //    InvokeRepeating("SendBullet", 0.0f, m_intervalTime);
        //}
        //for (int i = 1; i < m_bulletTrans.Length; i++)
        //{
        //    if(i >= m_index)
        //    {
        //        m_bulletTrans[i].transform.RotateAround(transform.position, -transform.up, Time.deltaTime * m_rotateSpeed);
        //    }
        //}
        UpdateUIBossBloodPos();
        UpdateMove();
    }
    //发射子弹
    void SendBullet()
    {
        if(BattleCtrl.instance.isEndBattle)
        {
            CancelInvokeBullet();
            return;
        }
        int varRand = Random.Range(0, 3);
        if(varRand == 0)
        {
            m_curBulletObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bulletFourObj);
            m_curBulletObj.transform.SetParent(transform);
            m_curBulletObj.transform.localPosition = Vector3.zero;
            m_curBulletObj.transform.localRotation = Quaternion.identity;
            m_curBulletObj.transform.localScale = Vector3.one;
            BulletTypeFourView varView = m_curBulletObj.GetComponent<BulletTypeFourView>();
            if(varView)
            {
                varView.Init();
            }
        }
        else
        {
            m_curBulletObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bulletEightObj);
            m_curBulletObj.transform.SetParent(transform);
            m_curBulletObj.transform.localPosition = Vector3.zero;
            m_curBulletObj.transform.localRotation = Quaternion.identity;
            m_curBulletObj.transform.localScale = Vector3.one;
            BulletTypeEightView varView = m_curBulletObj.GetComponent<BulletTypeEightView>();
            if (varView)
            {
                varView.Init();
            }
        }
        //做法1
        //if(m_index >= m_bulletTrans.Length)
        //{
        //    return;
        //}
        //m_index++;
        //BulletDamageView varDamage = m_bulletTrans[m_index - 1].GetComponent<BulletDamageView>();
        //if(varDamage)
        //{
        //    varDamage.StartMove(m_parent);
        //}
        //BulletSouthView varSouth = m_bulletTrans[m_index - 1].GetComponent<BulletSouthView>();
        //if (varSouth)
        //{
        //    varSouth.StartMove(m_parent);
        //}
        //BulletNorthView varNorth = m_bulletTrans[m_index - 1].GetComponent<BulletNorthView>();
        //if (varNorth)
        //{
        //    varNorth.StartMove(m_parent);
        //}
    }
    //更新UI血量位置
    void UpdateUIBossBloodPos()
    {
        Vector3 varVec3 = Camera.main.WorldToScreenPoint(transform.position);
        varVec3.x = (varVec3.x - Screen.width / 2f) / (Screen.height / GlobalConfig.NormalHeight);
        varVec3.y = (varVec3.y - Screen.height / 2f) / (Screen.height / GlobalConfig.NormalHeight) + 200.0f;
        BattleCtrl.instance.battleUI.SetBossBloodPos(varVec3.x, varVec3.y);
    }
    //移动
    void UpdateMove()
    {
        if(m_isMove && !m_bIsDie)
        {
            Vector3 varDir;
            if (m_bIsForWard)
            {
                varDir = m_movePointA - transform.position;
                transform.position += varDir.normalized * Time.deltaTime * m_moveSpeed;
                if (Vector3.SqrMagnitude(varDir) <= 0.2f)
                {
                    m_bIsForWard = false;
                }
            }
            else
            {
                varDir = m_movePointB - transform.position;
                transform.position += varDir.normalized * Time.deltaTime * m_moveSpeed;
                if (Vector3.SqrMagnitude(varDir) <= 0.2f)
                {
                    m_bIsForWard = true;
                }
            }
            Vector3 targetDir = varDir.normalized;
            if (!targetDir.Equals(Vector3.zero))
            {
                Quaternion targetRotation = Quaternion.LookRotation(targetDir, Vector3.up);
                transform.rotation = Quaternion.Lerp(transform.rotation, targetRotation, 0.2f);
            }
        }
    }
    void CancelInvokeBullet()
    {
        if (IsInvoking("SendBullet"))
        {
            CancelInvoke("SendBullet");
        }
    }
    private void OnDestroy()
    {
        CancelInvokeBullet();
    }
}
