﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;
#if UNITY_EDITOR
using UnityEditor;
#endif

public class BattleConfig : ScriptableObject
{
    public PlayerConfig playerConfig;
    public LevelConfig levelConfig;
    public AudioConfig audioConfig;


#if UNITY_EDITOR
    [MenuItem("Tools/Rope/生成战斗配置")]
    public static void GenBattleConfig()
    {
        string savePath = @"Assets/Resources/BattleConfig.asset";
        var data = ScriptableObject.CreateInstance("BattleConfig");
        AssetDatabase.CreateAsset(data, savePath);
    }
#endif

    /// <summary>
    /// 加载配置
    /// </summary>
    /// <returns></returns>
    public static BattleConfig LoadConfig()
    {
        return Resources.Load<BattleConfig>("BattleConfig");
    }
}

[Serializable]
public class PlayerConfig
{
    [Header("手移动的速度")]
    public float moveSpeed = 6;
    [Header("X方向最小距离")]
    public float xDirMinDis = -5;
    [Header("X方向最大距离")]
    public float xDirMaxDis = 5;
    [Header("Z方向最小距离")]
    public float yDirMinDis = -5;
    [Header("Z方向最大距离")]
    public float yDirMaxDis = 5;
    [Header("爪的最大角度")]
    public float clawMaxAngle = 30.0f;
    [Header("爪的旋转速度")]
    public float clawRotateSpeed = 20.0f;
    [Header("绳子缩减的速度")]
    public float ropeReduceSpeed = 2.0f;
    [Header("绳子伸长的速度")]
    public float ropeExtendSpeed = 3.0f;
    [Header("爪身的旋转速度")]
    public float clawBodyRotateSpeed = 2.0f;
    [Header("镜头移动速度")]
    public float cameraMoveSpeed = 2;
    [Header("镜头远近速度")]
    public float cameraFieldSpeed = 2;
}
[Serializable]
public class LevelConfig
{
    [Header("关卡3的地面位置")]
    public float landPosY = 1.9f;
    [Header("第一关目标名称")]
    public string firstLevelGoalName = "Tree_Star";
    [Header("第二关目标名称")]
    public string secondLevelGoalName = "Boy_01";
    [Header("第三关目标名称")]
    public string thirdLevelGoalName = "Boy_02";
    [Header("第四关目标名称")]
    public string fourthLevelGoalName = "SM_Prop_Crate_03 (2)";
    [Header("第五关目标名称")]
    public string fifthLevelGoalName1 = "BlueDark_BunnyBalloon";
    public string fifthLevelGoalName2 = "SM_Icon_Sword_01";
    public string fifthLevelGoalName3 = "SM_Primitive_Sphere_02";
    [Header("第六关目标名称")]
    public string sixthLevelGoalName = "SM_Primitive_Pyramid_01";
}
[Serializable]
public class AudioConfig
{
    [Header("pien死亡音效列表")]
    public List<AudioClip> pienDeads;
    [Header("成功通关")]
    public AudioClip win;
    [Header("失败音效")]
    public AudioClip fail;
    [Header("开枪")]
    public AudioClip shoot;
    [Header("电梯开门")]
    public AudioClip ElevatorOpen;
    [Header("失去钥匙")]
    public AudioClip keyPick;
    [Header("游戏bmg")]
    public AudioClip GameBgm;

    [Header("npc被救援")]
    public AudioClip npcRescue;

    [Header("npc被杀变为pien")]
    public AudioClip npc2pien;

    [Header("拾取枪")]
    public AudioClip gunPick;

    [Header("npc尖叫")]
    public AudioClip girlScream;

    /// <summary>
    /// 获取随机一个pien死亡叫声
    /// </summary>
    /// <returns></returns>
    public AudioClip GetPienDead()
    {
        int index =  UnityEngine.Random.Range(0, pienDeads.Count);
        return pienDeads[index];
    }
}
