﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

public class TargetView : MonoBehaviour
{
    public float m_clawMinAngle;//能被抓住的最小角度
    public bool m_bIsNeedSpecial = false;//是否需要特色处理
    public Transform m_parentTrans;//父节点
    public Transform parentTrans => m_parentTrans;
    public float clawMinAngle => m_clawMinAngle;
    private Rigidbody m_rigidBody;//刚体
    //private ChainView m_chainView;
    private ChainRopeView m_chainRopeView;//娃娃机爪钩
    private Transform m_parent;//父节点
    private FixedJoint m_fixedJoint;
    private float m_Angle;
    private bool m_isCollider;
    private Rigidbody m_otherRigidBody;
    public Rigidbody rigidBody => m_rigidBody;

    private void Awake()
    {
        if (m_parentTrans)
        {
            m_parent = m_parentTrans.parent;
        }
        else
        {
            m_parent = transform.parent;
        }
    }
    private void Start()
    {
        //m_chainView = BattleCtrl.instance.levelManager.curLevel.chainView;
        m_chainRopeView = BattleCtrl.instance.levelManager.curLevel.chainRopeView;
        m_rigidBody = gameObject.GetComponent<Rigidbody>();
    }
    private void OnCollisionEnter(Collision other)
    {
        if (string.Equals(other.gameObject.name, "Claw"))
        {
            BattleCtrl.instance.levelManager.curLevel.chainRopeView.EnterTargerView();
        }
    }
    //删除刚体
    public void DestroyRigidBody(Rigidbody body)
    {
        if (m_bIsNeedSpecial)
        {
            m_otherRigidBody = body;
            m_isCollider = true;
            m_Angle = transform.localRotation.eulerAngles.x;
            //如果默认没有，需要增加，避免进游戏人就起飞了
            if (!m_rigidBody)
            {
                m_rigidBody = gameObject.AddComponent<Rigidbody>();
            }
        }
        else
        {
            if (m_rigidBody)
            {
                GameObject.Destroy(m_rigidBody);
                m_rigidBody = null;
            }
        }
        if(m_parentTrans)
        {
            m_parentTrans.SetParent(m_chainRopeView.leftClawTrans.parent);
        }
        else
        {
            transform.SetParent(m_chainRopeView.leftClawTrans.parent);
        }
        //第一关抓取的需要设置layer
        //if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        {
            Transform[] varTrans = GetComponentsInChildren<Transform>();

            for (int i = 0; i < varTrans.Length; i++)
            {
                //第五关特殊处理，抓住之后layer不需要碰撞
                if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelFiveIndex)
                {
                    varTrans[i].gameObject.layer = 8;
                }
                else
                {
                    varTrans[i].gameObject.layer = 0;
                }
            }
        }
    }
    public void SetJoint()
    {
        if (m_fixedJoint)
        {
            return;
        }
        if (!m_fixedJoint)
        {
            m_fixedJoint = gameObject.AddComponent<FixedJoint>();
        }
        if (m_fixedJoint)
        {
            m_fixedJoint.connectedBody = m_otherRigidBody;
        }
    }
    //增加刚体
    public void AddRigidBody()
    {
        if (m_parentTrans)
        {
            m_parentTrans.SetParent(m_parent);
        }
        else
        {
            transform.SetParent(m_parent);
        }
        if(m_bIsNeedSpecial)
        {
            m_isCollider = false;
            if (m_fixedJoint)
            {
                GameObject.Destroy(m_fixedJoint);
                m_fixedJoint = null;
            }
        }
        else
        {
            if (!m_rigidBody)
            {
                m_rigidBody = gameObject.AddComponent<Rigidbody>();

                //特殊处理，第五关气球特殊处理
                if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelFiveIndex)
                {
                    m_rigidBody.useGravity = false;
                    m_rigidBody.constraints = RigidbodyConstraints.FreezePositionX | RigidbodyConstraints.FreezePositionZ |
                                              RigidbodyConstraints.FreezeRotationX | RigidbodyConstraints.FreezeRotationZ;
                }
            }
        }
        //if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        {
            Transform[] varTrans = GetComponentsInChildren<Transform>();

            for(int i = 0;i<varTrans.Length;i++)
            {
                varTrans[i].gameObject.layer = 1;
            }
        }
    }
    public void DestroyRigidByOther()
    {
        if (m_rigidBody)
        {
            GameObject.Destroy(m_rigidBody);
            m_rigidBody = null;
        }
    }
    //碰到胜利目标
    public void SetColliderSuccessTarget()
    {
        // 特殊处理，第五关气球特殊处理
        //if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelFiveIndex)
        //{
        //    return;
        //}
        if (m_rigidBody)
        {
            m_rigidBody.isKinematic = true;
        }
    }
    //能够被抓的东西
    public bool CanGetCatch()
    {
        return string.Equals(gameObject.name, GameServices.configService.levelConfig.firstLevelGoalName)
            || string.Equals(gameObject.name, GameServices.configService.levelConfig.secondLevelGoalName)
            || string.Equals(gameObject.name, GameServices.configService.levelConfig.thirdLevelGoalName)
            || string.Equals(gameObject.name, GameServices.configService.levelConfig.fourthLevelGoalName)
            || string.Equals(gameObject.name, GameServices.configService.levelConfig.fifthLevelGoalName1)
            || string.Equals(gameObject.name, GameServices.configService.levelConfig.fifthLevelGoalName2)
            || string.Equals(gameObject.name, GameServices.configService.levelConfig.fifthLevelGoalName3)
            || string.Equals(gameObject.name, GameServices.configService.levelConfig.sixthLevelGoalName);
    }
    private void Update()
    {
        //Vector3 angle = transform.localRotation.eulerAngles;
        //float x = angle.x;
        //if (Vector3.Dot(transform.up, Vector3.up) >= 0f)
        //{
        //    if (angle.x >= 0f && angle.x <= 90f)
        //    {
        //        x = angle.x;
        //    }
        //    if (angle.x >= 270f && angle.x <= 360f)
        //    {
        //        x = angle.x - 360f;
        //    }
        //}
        //if (Vector3.Dot(transform.up, Vector3.up) < 0f)
        //{
        //    if (angle.x >= 0f && angle.x <= 90f)
        //    {
        //        x = 180 - angle.x;
        //    }
        //    if (angle.x >= 270f && angle.x <= 360f)
        //    {
        //        x = 180 - angle.x;
        //    }
        //}
        //Vector3 varAngle = transform.localRotation.eulerAngles;
        //float varX = varAngle.x;
        //if (varX > 270f)
        //{
        //    varX = 360f - varAngle.x;
        //}
        if(m_bIsNeedSpecial)
        {
            if ((Vector3.Dot(transform.up, Vector3.up) >= 0.95f || Vector3.Dot(transform.up, Vector3.up) <= -0.95f)
                && m_isCollider)
            {
                SetJoint();
            }
        }
    }
}
