﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;
using System;

public class BattleUI : MonoBehaviour
{
    public Button m_dragBtn;
    public Button m_moveBtn;
    public Button m_restartBtn;
    public Button m_nextLevelBtn;
    public Button m_selectBtn;
    public Button m_tryAgain;//再来一次
    public Button m_startBtn;
    public Text m_levelText;
    public GameObject m_successObj;//胜利
    public GameObject m_selectLevelObj;//选择关卡节目
    public GameObject m_loseObj;//失败
    public GameObject m_startLogoObj;//开始Logo
    public Text m_gameBestTime;
    public Button m_posUpBtn;
    public Button m_posDownBtn;
    public Button m_fieldFarBtn;
    public Button m_fieldNearBtn;
    public Text m_cameraPosY;
    public Text m_cameraFieldView;
    public GameObject m_battleObj;//战斗UI
    public Action onStartBtn;
    public Action onPosUpBtn;
    public Action onPosDownBtn;
    public Action onFieldFarBtn;
    public Action onFieldNearBtn;
    void Awake()
    {
        m_dragBtn.onClick.AddListener(SetDragMode);
        m_moveBtn.onClick.AddListener(SetMoveMode);
        m_restartBtn.onClick.AddListener(LoadCurLevel);
        m_nextLevelBtn.onClick.AddListener(NextLevel);
        m_selectBtn.onClick.AddListener(SelectLevel);
        m_tryAgain.onClick.AddListener(TryAgainLevel);
        m_startBtn.onClick.AddListener(StartBtn);
        //m_posUpBtn.onClick.AddListener(PosUpBtn);
        //m_posDownBtn.onClick.AddListener(PosDownBtn);
        //m_fieldFarBtn.onClick.AddListener(FieldFarBtn);
        //m_fieldNearBtn.onClick.AddListener(FieldNearBtn);
    }
    void SetDragMode()
    {
        BattleCtrl.instance.levelManager.curLevel.chainView.SetDragMode(true);
    }
    void SetMoveMode()
    {
        BattleCtrl.instance.levelManager.curLevel.chainView.SetDragMode(false);
    }
    // 当前关卡再来一次
    void LoadCurLevel()
    {
        m_successObj.SetActive(false);
        BattleCtrl.instance.levelManager.LoadCurLevel();
        //SceneManager.LoadScene(0);
    }
    //再来一次
    void TryAgainLevel()
    {
        m_loseObj.SetActive(false);
        BattleCtrl.instance.levelManager.LoadCurLevel();
    }
    // 进入下一关卡
    void NextLevel()
    {
        m_successObj.SetActive(false);
        BattleCtrl.instance.levelManager.LoadNextLevel();
    }
    //选择关卡
    void SelectLevel()
    {
        m_selectLevelObj.SetActive(true);
    }
    //开始游戏
    void StartBtn()
    {
        onStartBtn?.Invoke();
        m_startBtn.gameObject.SetActive(false);
        m_startLogoObj.SetActive(false);
    }
    //镜头拉上
    public void PosUpBtn()
    {
        onPosUpBtn?.Invoke();
        Camera varCam = Camera.main;
        if(varCam)
        {
            m_cameraPosY.text = string.Format("pos{0:f3}", varCam.transform.position.y);
        }
    }
    //镜头拉下
    public void PosDownBtn()
    {
        onPosDownBtn?.Invoke();
        Camera varCam = Camera.main;
        if (varCam)
        {
            m_cameraPosY.text = string.Format("pos{0:f3}", varCam.transform.position.y);
        }
    }
    //镜头拉远
    public void FieldFarBtn()
    {
        onFieldFarBtn?.Invoke();
        Camera varCam = Camera.main;
        if (varCam)
        {
            m_cameraFieldView.text = string.Format("fieldView{0:f1}", varCam.fieldOfView);
        }
    }
    //镜头拉近
    public void FieldNearBtn()
    {
        onFieldNearBtn?.Invoke();
        Camera varCam = Camera.main;
        if (varCam)
        {
            m_cameraFieldView.text = string.Format("fieldView{0:f1}", varCam.fieldOfView);
        }
    }
    //胜利
    public void OnBattleWin()
    {
        m_successObj.SetActive(true);
        m_selectLevelObj.SetActive(false);
        int varCurTime = (int)BattleCtrl.instance.levelManager.curLevel.bestTime;
        m_gameBestTime.text = string.Format("{0:d2}:{1:d2}", varCurTime / 60, varCurTime % 60);
        //string varKey = BattleCtrl.instance.levelManager.CurLevelIndex.ToString();
        //if (LocalRecord.HasKey(varKey))
        //{
        //    int varBestTime = LocalRecord.GetIntRecord(varKey);
        //    if (varCurTime < varBestTime)
        //    {
        //        m_gameBestTime.text = string.Format("{0:d2}:{1:d2}", varCurTime / 60, varCurTime % 60);
        //    }
        //    else
        //    {
        //        m_gameBestTime.text = string.Format("{0:d2}:{1:d2}", varBestTime / 60, varBestTime % 60);
        //    }
        //}
        //else
        //{
        //    m_gameBestTime.text = string.Format("{0:d2}:{1:d2}", varCurTime / 60, varCurTime % 60);
        //}
    }
    //失败
    public void OnBattleFail()
    {
        m_loseObj.SetActive(true);
        m_selectLevelObj.SetActive(false);
    }
    /// 加载关卡前调用，隐藏不需要显示的ui
    public void OnBeforeLoadLevel()
    {
        m_selectLevelObj.SetActive(false);
        m_successObj.SetActive(false);
    }

    /// 加载关卡后调用
    public void OnAfterLoadLevel()
    {
        m_levelText.text = string.Format("Level {0:D}", BattleCtrl.instance.levelManager.CurLevelIndex + 1);

        Camera varCam = BattleCtrl.instance.levelManager.curLevel.cam;
        if (varCam)
        {
            m_cameraPosY.text = string.Format("pos{0:f3}", varCam.transform.position.y);
            m_cameraFieldView.text = string.Format("fieldView{0:f1}", varCam.fieldOfView);
        }
    }
    //设置战斗UI状态
    public void SetBattleObjState(bool bool_)
    {
        m_battleObj.SetActive(bool_);
    }
}
