﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ThirdLevelBoxCollision : MonoBehaviour
{
    public GameObject[] m_needRigidBody;
    public Transform m_targetTrans;
    public GameObject m_bottomObj;
    private bool m_bIsRigid = false;//是否有刚体
    private bool m_bIsTrigger = false;//是否碰到了目标
    private Vector3 m_pos = new Vector3(-0.73f, 1.19f, -2.54f);
    private Quaternion m_rotation = Quaternion.Euler(0, 83.33f, 0);
    private void OnCollisionEnter(Collision other)
    {
        if (string.Equals(other.gameObject.name, "Claw"))
        {
            m_bIsRigid = true;
            BattleCtrl.instance.levelManager.curLevel.chainRopeView.EnterTargerView();
            for(int i = 0;i< m_needRigidBody.Length;i++)
            {
                m_needRigidBody[i].AddComponent<Rigidbody>();
            }
            GameServices.timerServices.Push(this, 1.0f, delegate
            {
                for (int i = 0; i < m_needRigidBody.Length; i++)
                {
                    if(m_needRigidBody[i])
                    {
                        m_needRigidBody[i].SetActive(false);
                    }
                }
                if(m_bottomObj)
                {
                    m_bottomObj.SetActive(false);
                }
            });
            if (m_bIsTrigger && m_bIsRigid)
            {
                BattleCtrl.instance.OnBattleWin();
                //m_targetTrans.localPosition = m_pos;
                //m_targetTrans.localRotation = m_rotation;
            }
        }
    }
    //碰到了目标
    public void SetEnterTarget()
    {
        m_bIsTrigger = true;
        if(m_bIsTrigger && m_bIsRigid)
        {
            BattleCtrl.instance.OnBattleWin();
            //m_targetTrans.localPosition = m_pos;
            //m_targetTrans.localRotation = m_rotation;
        }
    }
}
