/*
 * Decompiled with CFR 0.152.
 */
package com.gameanalytics.sdk.imei;

import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.gameanalytics.sdk.imei.GAImei;
import com.gameanalytics.sdk.logging.GALogger;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TelephonyIdsUtil {
    static void injectImei(JSONObject parameters, Context context) {
        if (!GAImei.isImeiToBeRead) {
            return;
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        TelephonyIdsUtil.addStringToJson(parameters, "android_imei", TelephonyIdsUtil.getDefaultImei(telephonyManager));
        TelephonyIdsUtil.addStringToJson(parameters, "android_meid", TelephonyIdsUtil.getDefaultMeid(telephonyManager));
        TelephonyIdsUtil.addStringToJson(parameters, "android_device_id", TelephonyIdsUtil.getDefaultDeviceId(telephonyManager));
        TelephonyIdsUtil.addArrayToJson(parameters, "android_imeis", TelephonyIdsUtil.getImeis(telephonyManager));
        TelephonyIdsUtil.addArrayToJson(parameters, "android_meids", TelephonyIdsUtil.getMeids(telephonyManager));
        TelephonyIdsUtil.addArrayToJson(parameters, "android_device_ids", TelephonyIdsUtil.getDeviceIds(telephonyManager));
    }

    private static JSONArray getDeviceIds(TelephonyManager telephonyManager) {
        String telephonyId;
        ArrayList<String> telephonyIdList = new ArrayList<String>();
        for (int i = 0; i < 10 && TelephonyIdsUtil.tryAddToStringList(telephonyIdList, telephonyId = TelephonyIdsUtil.getDeviceIdByIndex(telephonyManager, i)); ++i) {
        }
        JSONArray result = new JSONArray();
        for (String s : telephonyIdList) {
            result.put((Object)s);
        }
        return result;
    }

    private static String getDefaultDeviceId(TelephonyManager telephonyManager) {
        try {
            return telephonyManager.getDeviceId();
        }
        catch (SecurityException e) {
            GALogger.d((String)String.format("Couldn't read default Device Id: %s", e.getMessage()));
            return null;
        }
    }

    private static String getDeviceIdByIndex(TelephonyManager telephonyManager, int index) {
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                return telephonyManager.getDeviceId(index);
            }
        }
        catch (SecurityException e) {
            GALogger.d((String)String.format("Couldn't read Device Id in position %d: %s", index, e.getMessage()));
        }
        return null;
    }

    private static JSONArray getImeis(TelephonyManager telephonyManager) {
        String imei;
        ArrayList<String> imeiList = new ArrayList<String>();
        for (int i = 0; i < 10 && TelephonyIdsUtil.tryAddToStringList(imeiList, imei = TelephonyIdsUtil.getImeiByIndex(telephonyManager, i)); ++i) {
        }
        JSONArray result = new JSONArray();
        for (String s : imeiList) {
            result.put((Object)s);
        }
        return result;
    }

    private static String getDefaultImei(TelephonyManager telephonyManager) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                return telephonyManager.getImei();
            }
        }
        catch (SecurityException e) {
            GALogger.d((String)String.format("Couldn't read default IMEI: %s", e.getMessage()));
        }
        return null;
    }

    private static String getImeiByIndex(TelephonyManager telephonyManager, int index) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                return telephonyManager.getImei(index);
            }
        }
        catch (SecurityException e) {
            GALogger.d((String)String.format("Couldn't read IMEI in position %d: %s", index, e.getMessage()));
        }
        return null;
    }

    public static JSONArray getMeids(TelephonyManager telephonyManager) {
        String meid;
        ArrayList<String> meidList = new ArrayList<String>();
        for (int i = 0; i < 10 && TelephonyIdsUtil.tryAddToStringList(meidList, meid = TelephonyIdsUtil.getMeidByIndex(telephonyManager, i)); ++i) {
        }
        JSONArray result = new JSONArray();
        for (String s : meidList) {
            result.put((Object)s);
        }
        return result;
    }

    private static String getDefaultMeid(TelephonyManager telephonyManager) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                return telephonyManager.getMeid();
            }
        }
        catch (SecurityException e) {
            GALogger.d((String)String.format("Couldn't read default MEID: %s", e.getMessage()));
        }
        return null;
    }

    private static String getMeidByIndex(TelephonyManager telephonyManager, int index) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                return telephonyManager.getMeid(index);
            }
        }
        catch (SecurityException e) {
            GALogger.d((String)String.format("Couldn't read MEID in position %d: %s", index, e.getMessage()));
        }
        return null;
    }

    private static boolean tryAddToStringList(List<String> list, String value) {
        if (value == null) {
            return false;
        }
        if (list.contains(value)) {
            return false;
        }
        return list.add(value);
    }

    private static void addStringToJson(JSONObject json, String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        try {
            json.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private static void addArrayToJson(JSONObject json, String key, JSONArray value) {
        if (value == null || value.length() == 0) {
            return;
        }
        try {
            json.put(key, (Object)value);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

