/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.collection.ContainerHelpers;
import java.util.ConcurrentModificationException;
import java.util.Map;

public class SimpleArrayMap<K, V> {
    private static final boolean DEBUG = false;
    private static final String TAG = "ArrayMap";
    private static final boolean CONCURRENT_MODIFICATION_EXCEPTIONS = true;
    private static final int BASE_SIZE = 4;
    private static final int CACHE_SIZE = 10;
    @Nullable
    static Object[] mBaseCache;
    static int mBaseCacheSize;
    @Nullable
    static Object[] mTwiceBaseCache;
    static int mTwiceBaseCacheSize;
    int[] mHashes;
    Object[] mArray;
    int mSize;

    private static int binarySearchHashes(int[] hashes, int N, int hash) {
        try {
            return ContainerHelpers.binarySearch(hashes, N, hash);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ConcurrentModificationException();
        }
    }

    int indexOf(Object key, int hash) {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = SimpleArrayMap.binarySearchHashes(this.mHashes, N, hash);
        if (index < 0) {
            return index;
        }
        if (key.equals(this.mArray[index << 1])) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == hash; ++end) {
            if (!key.equals(this.mArray[end << 1])) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == hash; --i) {
            if (!key.equals(this.mArray[i << 1])) continue;
            return i;
        }
        return ~end;
    }

    int indexOfNull() {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = SimpleArrayMap.binarySearchHashes(this.mHashes, N, 0);
        if (index < 0) {
            return index;
        }
        if (null == this.mArray[index << 1]) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == 0; ++end) {
            if (null != this.mArray[end << 1]) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == 0; --i) {
            if (null != this.mArray[i << 1]) continue;
            return i;
        }
        return ~end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void allocArrays(int size) {
        if (size == 8) {
            Class<ArrayMap> clazz = ArrayMap.class;
            // MONITORENTER : androidx.collection.ArrayMap.class
            if (mTwiceBaseCache != null) {
                Object[] array = mTwiceBaseCache;
                this.mArray = array;
                mTwiceBaseCache = (Object[])array[0];
                this.mHashes = (int[])array[1];
                array[1] = null;
                array[0] = null;
                --mTwiceBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        } else if (size == 4) {
            Class<ArrayMap> clazz = ArrayMap.class;
            // MONITORENTER : androidx.collection.ArrayMap.class
            if (mBaseCache != null) {
                Object[] array = mBaseCache;
                this.mArray = array;
                mBaseCache = (Object[])array[0];
                this.mHashes = (int[])array[1];
                array[1] = null;
                array[0] = null;
                --mBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        this.mHashes = new int[size];
        this.mArray = new Object[size << 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void freeArrays(int[] hashes, Object[] array, int size) {
        if (hashes.length == 8) {
            Class<ArrayMap> clazz = ArrayMap.class;
            synchronized (ArrayMap.class) {
                if (mTwiceBaseCacheSize >= 10) return;
                array[0] = mTwiceBaseCache;
                array[1] = hashes;
                for (int i = (size << 1) - 1; i >= 2; --i) {
                    array[i] = null;
                }
                mTwiceBaseCache = array;
                ++mTwiceBaseCacheSize;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
        if (hashes.length != 4) return;
        Class<ArrayMap> clazz = ArrayMap.class;
        synchronized (ArrayMap.class) {
            if (mBaseCacheSize >= 10) return;
            array[0] = mBaseCache;
            array[1] = hashes;
            for (int i = (size << 1) - 1; i >= 2; --i) {
                array[i] = null;
            }
            mBaseCache = array;
            ++mBaseCacheSize;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public SimpleArrayMap() {
        this.mHashes = ContainerHelpers.EMPTY_INTS;
        this.mArray = ContainerHelpers.EMPTY_OBJECTS;
        this.mSize = 0;
    }

    public SimpleArrayMap(int capacity) {
        if (capacity == 0) {
            this.mHashes = ContainerHelpers.EMPTY_INTS;
            this.mArray = ContainerHelpers.EMPTY_OBJECTS;
        } else {
            this.allocArrays(capacity);
        }
        this.mSize = 0;
    }

    public SimpleArrayMap(SimpleArrayMap<K, V> map) {
        this();
        if (map != null) {
            this.putAll(map);
        }
    }

    public void clear() {
        if (this.mSize > 0) {
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            int osize = this.mSize;
            this.mHashes = ContainerHelpers.EMPTY_INTS;
            this.mArray = ContainerHelpers.EMPTY_OBJECTS;
            this.mSize = 0;
            SimpleArrayMap.freeArrays(ohashes, oarray, osize);
        }
        if (this.mSize > 0) {
            throw new ConcurrentModificationException();
        }
    }

    public void ensureCapacity(int minimumCapacity) {
        int osize = this.mSize;
        if (this.mHashes.length < minimumCapacity) {
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(minimumCapacity);
            if (this.mSize > 0) {
                System.arraycopy(ohashes, 0, this.mHashes, 0, osize);
                System.arraycopy(oarray, 0, this.mArray, 0, osize << 1);
            }
            SimpleArrayMap.freeArrays(ohashes, oarray, osize);
        }
        if (this.mSize != osize) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean containsKey(@Nullable Object key) {
        return this.indexOfKey(key) >= 0;
    }

    public int indexOfKey(@Nullable Object key) {
        return key == null ? this.indexOfNull() : this.indexOf(key, key.hashCode());
    }

    int indexOfValue(Object value) {
        int N = this.mSize * 2;
        Object[] array = this.mArray;
        if (value == null) {
            for (int i = 1; i < N; i += 2) {
                if (array[i] != null) continue;
                return i >> 1;
            }
        } else {
            for (int i = 1; i < N; i += 2) {
                if (!value.equals(array[i])) continue;
                return i >> 1;
            }
        }
        return -1;
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    @Nullable
    public V get(Object key) {
        int index = this.indexOfKey(key);
        return (V)(index >= 0 ? this.mArray[(index << 1) + 1] : null);
    }

    public K keyAt(int index) {
        return (K)this.mArray[index << 1];
    }

    public V valueAt(int index) {
        return (V)this.mArray[(index << 1) + 1];
    }

    public V setValueAt(int index, V value) {
        index = (index << 1) + 1;
        Object old = this.mArray[index];
        this.mArray[index] = value;
        return (V)old;
    }

    public boolean isEmpty() {
        return this.mSize <= 0;
    }

    @Nullable
    public V put(K key, V value) {
        int index;
        int hash;
        int osize = this.mSize;
        if (key == null) {
            hash = 0;
            index = this.indexOfNull();
        } else {
            hash = key.hashCode();
            index = this.indexOf(key, hash);
        }
        if (index >= 0) {
            index = (index << 1) + 1;
            Object old = this.mArray[index];
            this.mArray[index] = value;
            return (V)old;
        }
        index ^= 0xFFFFFFFF;
        if (osize >= this.mHashes.length) {
            int n = osize >= 8 ? osize + (osize >> 1) : (osize >= 4 ? 8 : 4);
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(n);
            if (osize != this.mSize) {
                throw new ConcurrentModificationException();
            }
            if (this.mHashes.length > 0) {
                System.arraycopy(ohashes, 0, this.mHashes, 0, ohashes.length);
                System.arraycopy(oarray, 0, this.mArray, 0, oarray.length);
            }
            SimpleArrayMap.freeArrays(ohashes, oarray, osize);
        }
        if (index < osize) {
            System.arraycopy(this.mHashes, index, this.mHashes, index + 1, osize - index);
            System.arraycopy(this.mArray, index << 1, this.mArray, index + 1 << 1, this.mSize - index << 1);
        }
        if (osize != this.mSize || index >= this.mHashes.length) {
            throw new ConcurrentModificationException();
        }
        this.mHashes[index] = hash;
        this.mArray[index << 1] = key;
        this.mArray[(index << 1) + 1] = value;
        ++this.mSize;
        return null;
    }

    public void putAll(@NonNull SimpleArrayMap<? extends K, ? extends V> array) {
        int N = array.mSize;
        this.ensureCapacity(this.mSize + N);
        if (this.mSize == 0) {
            if (N > 0) {
                System.arraycopy(array.mHashes, 0, this.mHashes, 0, N);
                System.arraycopy(array.mArray, 0, this.mArray, 0, N << 1);
                this.mSize = N;
            }
        } else {
            for (int i = 0; i < N; ++i) {
                this.put(array.keyAt(i), array.valueAt(i));
            }
        }
    }

    @Nullable
    public V remove(Object key) {
        int index = this.indexOfKey(key);
        if (index >= 0) {
            return this.removeAt(index);
        }
        return null;
    }

    public V removeAt(int index) {
        int nsize;
        Object old = this.mArray[(index << 1) + 1];
        int osize = this.mSize;
        if (osize <= 1) {
            SimpleArrayMap.freeArrays(this.mHashes, this.mArray, osize);
            this.mHashes = ContainerHelpers.EMPTY_INTS;
            this.mArray = ContainerHelpers.EMPTY_OBJECTS;
            nsize = 0;
        } else {
            nsize = osize - 1;
            if (this.mHashes.length > 8 && this.mSize < this.mHashes.length / 3) {
                int n = osize > 8 ? osize + (osize >> 1) : 8;
                int[] ohashes = this.mHashes;
                Object[] oarray = this.mArray;
                this.allocArrays(n);
                if (osize != this.mSize) {
                    throw new ConcurrentModificationException();
                }
                if (index > 0) {
                    System.arraycopy(ohashes, 0, this.mHashes, 0, index);
                    System.arraycopy(oarray, 0, this.mArray, 0, index << 1);
                }
                if (index < nsize) {
                    System.arraycopy(ohashes, index + 1, this.mHashes, index, nsize - index);
                    System.arraycopy(oarray, index + 1 << 1, this.mArray, index << 1, nsize - index << 1);
                }
            } else {
                if (index < nsize) {
                    System.arraycopy(this.mHashes, index + 1, this.mHashes, index, nsize - index);
                    System.arraycopy(this.mArray, index + 1 << 1, this.mArray, index << 1, nsize - index << 1);
                }
                this.mArray[nsize << 1] = null;
                this.mArray[(nsize << 1) + 1] = null;
            }
        }
        if (osize != this.mSize) {
            throw new ConcurrentModificationException();
        }
        this.mSize = nsize;
        return (V)old;
    }

    public int size() {
        return this.mSize;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SimpleArrayMap) {
            SimpleArrayMap map = (SimpleArrayMap)object;
            if (this.size() != map.size()) {
                return false;
            }
            try {
                for (int i = 0; i < this.mSize; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    V theirs = map.get(key);
                    if (!(mine == null ? theirs != null || !map.containsKey(key) : !mine.equals(theirs))) continue;
                    return false;
                }
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() != map.size()) {
                return false;
            }
            try {
                for (int i = 0; i < this.mSize; ++i) {
                    K key = this.keyAt(i);
                    V mine = this.valueAt(i);
                    Object theirs = map.get(key);
                    if (!(mine == null ? theirs != null || !map.containsKey(key) : !mine.equals(theirs))) continue;
                    return false;
                }
            }
            catch (NullPointerException ignored) {
                return false;
            }
            catch (ClassCastException ignored) {
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int[] hashes = this.mHashes;
        Object[] array = this.mArray;
        int result = 0;
        int i = 0;
        int v = 1;
        int s = this.mSize;
        while (i < s) {
            Object value = array[v];
            result += hashes[i] ^ (value == null ? 0 : value.hashCode());
            ++i;
            v += 2;
        }
        return result;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            K key;
            if (i > 0) {
                buffer.append(", ");
            }
            if ((key = this.keyAt(i)) != this) {
                buffer.append(key);
            } else {
                buffer.append("(this Map)");
            }
            buffer.append('=');
            V value = this.valueAt(i);
            if (value != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        return buffer.toString();
    }
}

