﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class PropSelectUI : MonoBehaviour
{
    public GameObject m_strengthObj;
    public GameObject m_doubleObj;
    public GameObject m_coinObj;
    public GameObject m_KnifeObj;

    public GameObject m_strengthSymbolObj;
    public GameObject m_doubleSymbolObj;
    public GameObject m_coinSymbolObj;
    public GameObject m_KnifeSymbolObj;

    public GameObject m_strengthMaskObj;
    public GameObject m_doubleMaskObj;
    public GameObject m_coinMaskObj;
    public GameObject m_KnifeMaskObj;

    public Button m_strengthButton;
    public Button m_doubleButton;
    public Button m_coinButton;
    public Button m_KnifeButton;

    private int m_needMoneyOne = 0;
    private int m_needMoneyTwo = 0;
    private int m_needMoneyThree = 0;
    private int m_needMoneyFour = 0;

    //private bool m_bIsBuyOne;
    //private bool m_bIsBuyTwo;
    //private bool m_bIsBuyThree;
    private bool m_bIsBuy;
    private void Awake()
    {
        m_strengthButton = m_strengthObj.GetComponent<Button>();
        m_doubleButton = m_doubleObj.GetComponent<Button>();
        m_coinButton = m_coinObj.GetComponent<Button>();
        m_KnifeButton = m_KnifeObj.GetComponent<Button>();
    }
    public void Show()
    {
        gameObject.SetActive(true);
        int varCoin = LocalRecord.GetIntRecord(GlobalConfig.CoinReCordKey);
        m_strengthObj.SetActive(true);
        m_doubleObj.SetActive(true);
        m_coinObj.SetActive(true);
        m_KnifeObj.SetActive(true);
        m_strengthMaskObj.SetActive(varCoin < m_needMoneyOne);
        m_doubleMaskObj.SetActive(varCoin < m_needMoneyTwo);
        m_coinMaskObj.SetActive(varCoin < m_needMoneyThree);
        m_KnifeMaskObj.SetActive(varCoin < m_needMoneyFour);
        m_strengthSymbolObj.SetActive(false);
        m_doubleSymbolObj.SetActive(false);
        m_coinSymbolObj.SetActive(false);
        m_KnifeSymbolObj.SetActive(false);
        if (m_strengthButton)
        {
            m_strengthButton.enabled = varCoin >= m_needMoneyOne;
        }
        if (m_doubleButton)
        {
            m_doubleButton.enabled = varCoin >= m_needMoneyTwo;
        }
        if (m_coinButton)
        {
            m_coinButton.enabled = varCoin >= m_needMoneyThree;
        }
        if(m_KnifeButton)
        {
            m_KnifeButton.enabled = varCoin >= m_needMoneyFour;
        }
        //m_bIsBuyOne = false;
        //m_bIsBuyTwo = false;
        //m_bIsBuyThree = false;
        m_bIsBuy = false;
        GameServices.timerServices.Push(this, 0.5f, delegate
        {
            BattleCtrl.instance.levelManager.curLevel.bombView.CreateProp3Model();
        });
    }
    public void SetState(bool value)
    {
        int varCoin = LocalRecord.GetIntRecord(GlobalConfig.CoinReCordKey);
        m_strengthMaskObj.SetActive(!value || varCoin < m_needMoneyOne || m_bIsBuy);
        m_doubleMaskObj.SetActive(!value || varCoin < m_needMoneyTwo || m_bIsBuy);
        m_coinMaskObj.SetActive(!value || varCoin < m_needMoneyThree || m_bIsBuy);
        m_KnifeMaskObj.SetActive(!value || varCoin < m_needMoneyFour || m_bIsBuy);
        m_strengthButton.enabled = value && varCoin >= m_needMoneyOne && !m_bIsBuy;
        m_doubleButton.enabled = value && varCoin >= m_needMoneyTwo && !m_bIsBuy;
        m_coinButton.enabled = value && varCoin >= m_needMoneyThree && !m_bIsBuy;
        m_KnifeButton.enabled = value && varCoin >= m_needMoneyFour && !m_bIsBuy;
    }
    //点击加强
    public void OnClickStrength()
    {
        //BattleCtrl.instance.battleUI.SetBombStrength();
        BattleCtrl.instance.battleUI.SetCoin(-m_needMoneyOne);
        m_bIsBuy = true;
        SetOpenState();
        //m_strengthObj.SetActive(false);
        m_strengthMaskObj.SetActive(true);
        m_strengthButton.enabled = false;
        m_strengthSymbolObj.SetActive(true);
        BattleCtrl.instance.levelManager.curLevel.bombView.CreateProp1Model();
    }
    //点击double
    public void OnClickDouble()
    {
        //BattleCtrl.instance.battleUI.SetBombDouble();
        BattleCtrl.instance.battleUI.SetCoin(-m_needMoneyTwo);
        m_bIsBuy = true;
        SetOpenState();
        //m_doubleObj.SetActive(false);
        m_doubleMaskObj.SetActive(true);
        m_doubleButton.enabled = false;
        m_doubleSymbolObj.SetActive(true);
        BattleCtrl.instance.levelManager.curLevel.bombView.CreateProp2Model();
    }
    //点击金币
    public void OnClickCoin()
    {
        //BattleCtrl.instance.battleUI.SetCoinDouble();
        BattleCtrl.instance.battleUI.SetCoin(-m_needMoneyThree);
        m_bIsBuy = true;
        SetOpenState();
        //m_coinObj.SetActive(false);
        m_coinMaskObj.SetActive(true);
        m_coinButton.enabled = false;
        m_coinSymbolObj.SetActive(true);
        BattleCtrl.instance.levelManager.curLevel.bombView.CreateProp3Model();
    }
    //点击🔪
    public void OnClickKnift()
    {
        BattleCtrl.instance.battleUI.SetCoin(-m_needMoneyFour);
        m_bIsBuy = true;
        SetOpenState();
        m_KnifeMaskObj.SetActive(true);
        m_KnifeButton.enabled = false;
        m_KnifeSymbolObj.SetActive(true);
        BattleCtrl.instance.levelManager.curLevel.bombView.CreateProp4Model();
    }
    //开始
    public void OnClickStart()
    {
        gameObject.SetActive(false);
        Invoke("DelayHandle", 0.1f);
    }
    void DelayHandle()
    {
        BattleCtrl.instance.SelectPropState = false;
    }
    //设置open状态
    void SetOpenState()
    {
        int varCoin = LocalRecord.GetIntRecord(GlobalConfig.CoinReCordKey);
        //if(m_strengthObj.activeSelf)
        //{
        //    m_strengthObj.SetActive(varCoin >= 10);
        //}
        //if(m_doubleObj.activeSelf)
        //{
        //    m_doubleObj.SetActive(varCoin >= 20);
        //}
        //if(m_coinObj.activeSelf)
        //{
        //    m_coinObj.SetActive(varCoin >= 10);
        //}
        m_strengthMaskObj.SetActive(varCoin < m_needMoneyOne || m_bIsBuy);
        m_doubleMaskObj.SetActive(varCoin < m_needMoneyTwo || m_bIsBuy);
        m_coinMaskObj.SetActive(varCoin < m_needMoneyThree || m_bIsBuy);
        m_KnifeMaskObj.SetActive(varCoin < m_needMoneyThree || m_bIsBuy);
        m_strengthButton.enabled = varCoin >= m_needMoneyOne && !m_bIsBuy;
        m_doubleButton.enabled = varCoin >= m_needMoneyTwo && !m_bIsBuy;
        m_coinButton.enabled = varCoin >= m_needMoneyThree && !m_bIsBuy;
        m_KnifeButton.enabled = varCoin >= m_needMoneyFour && !m_bIsBuy;
    }
}
