﻿using RayFire;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class GameManager : MonoBehaviour
{
    public static GameManager Instance;

    private RayfireBomb curBomb;

    public bool canBePlace = true;

    [SerializeField]
    private GameObject fxGO;

    [SerializeField]
    private Button BoomBtn;

    [SerializeField]
    private GameObject uiPop;

    [SerializeField]
    public GameObject[] boomUIS;

    private int curIndex = 0;

    private void Awake()
    {
        Instance = this;
    }

    private void Start()
    {
        BoomBtn.interactable = false;
    }

    public void SetBomb(RayfireBomb rayfireBomb)
    {
        if (curIndex >= 3)
            return;
        if (uiPop != null)
            Destroy(uiPop);

        curBomb = rayfireBomb;
        BoomBtn.interactable = true;
        canBePlace = false;

        
        boomUIS[curIndex].SetActive(false);
        curIndex++;
        

    }

    public void OnClickBoomBtn()
    {
        if (curIndex ==4)
        {
            return;
        }
        GameObject fx = Instantiate(fxGO);
        fx.transform.position = curBomb.transform.position;
        curBomb?.Explode(0);
        curBomb.gameObject.SetActive(false);
        canBePlace = true;
        if (curIndex == 3)
        {
            curIndex++;
            canBePlace = false;
        }
            
    }

    public void OnClickReloadBtn()
    {
        SceneManager.LoadScene("BombScenes");
    }


}
