﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ChainView : MonoBehaviour
{
    public Rigidbody m_rigidBody;//刚体
    public Transform m_leftClawTrans;//左爪
    public Transform m_rightClawTrans;//右爪
    public Transform leftClawTrans => m_leftClawTrans;
    private Vector3 screenPoint;
    private Vector3 offset;
    private float m_addAngleSpeed = 0.0f;//角度增加的速度
    private bool m_bPress = false;//是否按下
    private bool m_bIsHitLeftClaw = false;//是否撞到左爪
    private bool m_bIsHitRightClaw = false;//是否撞到右爪
    private bool m_bIsDragMode = false;//是否拖动模式
    private bool m_bIsMaxAngle = true;//是否旋转到最大角度
    private bool m_bIsCatch = false;//是否抓住
    private bool m_bControlTouchUp = false;//控制松开
    private TargetView m_targetView;//目标碰撞view
    private GameObject m_leftTargetObj;//左边碰撞的obj
    private GameObject m_rightTargetObj;//右边碰撞的obj
    private bool m_bFirstMoveUp = false;//是否第一移动完松手

    void OnMouseDown()
    {
        if(m_bIsDragMode)
        {
            screenPoint = Camera.main.WorldToScreenPoint(gameObject.transform.position);
            offset = gameObject.transform.position - Camera.main.ScreenToWorldPoint(new Vector3(Input.mousePosition.x, Input.mousePosition.y, screenPoint.z));
        }
    }

    void OnMouseDrag()
    {
        if (m_bIsDragMode)
        {
            Vector3 curScreenPoint = new Vector3(Input.mousePosition.x, Input.mousePosition.y, screenPoint.z);
            transform.position = Camera.main.ScreenToWorldPoint(curScreenPoint) + offset;
        }
    }
    void Start()
    {
        GameServices.inputService.pad.onMoveVec3 += OnMove;
        GameServices.inputService.pad.onTouchUp += OnTouchUp;
        m_addAngleSpeed = GameServices.configService.playerConfig.clawMaxAngle;//开始最大角度
        m_leftClawTrans.localRotation = Quaternion.Euler(0, 0, -m_addAngleSpeed);
        m_rightClawTrans.localRotation = Quaternion.Euler(0, 0, m_addAngleSpeed);
    }
    //碰到左爪
    public void EnterLeftClaw(GameObject obj)
    {
        if (m_bControlTouchUp) return;//松手的时候不做碰撞判断
        m_leftTargetObj = obj;
        if(m_rightTargetObj && m_leftTargetObj.Equals(m_rightTargetObj))
        {
            m_targetView = obj.GetComponent<TargetView>();
        }
        m_bIsHitLeftClaw = true;
    }
    public void ExitLeftClaw()
    {
        m_bIsHitLeftClaw = false;
    }
    //碰到右爪
    public void EnterRightClaw(GameObject obj)
    {
        if (m_bControlTouchUp) return;//松手的时候不做碰撞判断
        m_rightTargetObj = obj;
        if (m_leftTargetObj && m_rightTargetObj.Equals(m_leftTargetObj))
        {
            m_targetView = obj.GetComponent<TargetView>();
        }
        m_bIsHitRightClaw = true;
    }
    public void ExitRightClaw()
    {
        m_bIsHitRightClaw = false;
    }
    //设置drag模式
    public void SetDragMode(bool bool_)
    {
        m_bIsDragMode = bool_;
    }
    //移动
    void OnMove(Vector3 dir)
    {
        //m_bPress = true;
        m_bFirstMoveUp = true;
        if (m_bIsDragMode)
        {
            return;
        }
        if (dir == Vector3.zero)
        {
            return;
        }
        dir = dir * GameServices.configService.playerConfig.moveSpeed;

        //transform.Translate(dir * Time.deltaTime, Space.World);
        transform.position = transform.position + dir * Time.deltaTime;
    }
    // 抬起回调
    void OnTouchUp()
    {
        //方式2
        if (m_bFirstMoveUp)
        {
            m_bFirstMoveUp = false;
            return;
        }
        if(m_bIsCatch)
        {
            m_bPress = false;
            m_bIsHitLeftClaw = false;
            m_bIsHitRightClaw = false;
            m_bIsCatch = false;
            m_bControlTouchUp = true;
            GameServices.timerServices.Push(this, 0.5f, delegate
            {
                m_bControlTouchUp = false;
            });
            if (m_targetView)
            {
                m_targetView.AddRigidBody();
                m_targetView = null;
                m_leftTargetObj = null;
                m_rightTargetObj = null;
            }
        }
        else
        {
            m_bPress = true;
            m_bIsMaxAngle = true;
        }
        //方式1
        //m_bPress = false;
        //m_bIsHitLeftClaw = false;
        //m_bIsHitRightClaw = false;
        //m_bIsCatch = false;
        //m_bControlTouchUp = true;
        //GameServices.timerServices.Push(this, 0.5f, delegate
        //{
        //    m_bControlTouchUp = false;
        //});
        //if(m_targetView)
        //{
        //    m_targetView.AddRigidBody();
        //    m_targetView = null;
        //    m_leftTargetObj = null;
        //    m_rightTargetObj = null;
        //}
    }
    void Update()
    {
        transform.localPosition = new Vector3(Mathf.Clamp(transform.localPosition.x, GameServices.configService.playerConfig.xDirMinDis, GameServices.configService.playerConfig.xDirMaxDis),
                                               Mathf.Clamp(transform.localPosition.y, GameServices.configService.playerConfig.yDirMinDis, GameServices.configService.playerConfig.yDirMaxDis),
                                               0);
        float varMaxAngle = GameServices.configService.playerConfig.clawMaxAngle;
        float varRotateSpeed = GameServices.configService.playerConfig.clawRotateSpeed;
        if(m_bIsCatch)
        {
            return;
        }
        //方式1
        //if (m_bPress)
        //{
        //    if(m_bIsMaxAngle)
        //    {
        //        m_addAngleSpeed -= Time.deltaTime * varRotateSpeed;
        //        if(m_addAngleSpeed <= 0)
        //        {
        //            m_addAngleSpeed = 0;
        //            m_bIsMaxAngle = false;
        //        }
        //    }
        //    else
        //    {
        //        m_bIsHitLeftClaw = false;
        //        m_bIsHitRightClaw = false;//爪子松开不做抓取判断
        //        m_addAngleSpeed += Time.deltaTime * varRotateSpeed;
        //        if (m_addAngleSpeed >= varMaxAngle)
        //        {
        //            m_addAngleSpeed = varMaxAngle;
        //            m_bIsMaxAngle = true;
        //        }
        //    }
        //    m_leftClawTrans.localRotation = Quaternion.Euler(0, 0, -m_addAngleSpeed);
        //    m_rightClawTrans.localRotation = Quaternion.Euler(0, 0, m_addAngleSpeed);
        //}
        //else
        //{
        //    m_addAngleSpeed += Time.deltaTime * varRotateSpeed;
        //    if (m_addAngleSpeed >= varMaxAngle)
        //    {
        //        m_addAngleSpeed = varMaxAngle;
        //        m_bIsMaxAngle = true;
        //    }
        //    m_leftClawTrans.localRotation = Quaternion.Euler(0, 0, -m_addAngleSpeed);
        //    m_rightClawTrans.localRotation = Quaternion.Euler(0, 0, m_addAngleSpeed);
        //}
        //方式2
        if (m_bPress)
        {
            if (m_bIsMaxAngle)
            {
                m_addAngleSpeed -= Time.deltaTime * varRotateSpeed;
                if (m_addAngleSpeed <= 0)
                {
                    m_addAngleSpeed = 0;
                    m_bIsMaxAngle = false;
                }
            }
            else
            {
                m_addAngleSpeed += Time.deltaTime * varRotateSpeed;
                if (m_addAngleSpeed >= varMaxAngle)
                {
                    m_addAngleSpeed = varMaxAngle;
                }
            }
            m_leftClawTrans.localRotation = Quaternion.Euler(0, 0, -m_addAngleSpeed);
            m_rightClawTrans.localRotation = Quaternion.Euler(0, 0, m_addAngleSpeed);
        }
        else
        {
            m_addAngleSpeed += Time.deltaTime * varRotateSpeed;
            if (m_addAngleSpeed >= varMaxAngle)
            {
                m_addAngleSpeed = varMaxAngle;
                m_bIsMaxAngle = true;
            }
            m_leftClawTrans.localRotation = Quaternion.Euler(0, 0, -m_addAngleSpeed);
            m_rightClawTrans.localRotation = Quaternion.Euler(0, 0, m_addAngleSpeed);
        }
    }
    void LateUpdate()
    {
        if (m_bIsHitLeftClaw && m_bIsHitRightClaw && !m_bIsCatch 
            && m_targetView && m_addAngleSpeed >= m_targetView.clawMinAngle)
        {
            m_bIsCatch = true;
            m_targetView.DestroyRigidBody(m_rigidBody);
        }
    }
    void OnDestroy()
    {
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onMoveVec3 -= OnMove;
            GameServices.inputService.pad.onTouchUp -= OnTouchUp;
        }
    }
}
