﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CameraMove : MonoBehaviour
{
    private float m_PosY;
    private float m_FieldView;
    private Camera m_camera;
    // Start is called before the first frame update
    void Start()
    {
        m_camera = gameObject.GetComponent<Camera>();
        m_PosY = transform.position.y;
        m_FieldView = m_camera.fieldOfView;
        BattleCtrl.instance.battleUI.onPosUpBtn = CameraPosUp;
        BattleCtrl.instance.battleUI.onPosDownBtn = CameraPosDown;
        BattleCtrl.instance.battleUI.onFieldFarBtn = CameraFieldFar;
        BattleCtrl.instance.battleUI.onFieldNearBtn = CameraFieldNear;
    }
    //镜头拉上
    void CameraPosUp()
    {
        Vector3 varVec = transform.position;
        varVec.y += Time.deltaTime * GameServices.configService.playerConfig.cameraMoveSpeed;
        transform.position = varVec;
    }
    //镜头拉下
    void CameraPosDown()
    {
        Vector3 varVec = transform.position;
        varVec.y -= Time.deltaTime * GameServices.configService.playerConfig.cameraMoveSpeed;
        transform.position = varVec;
    }
    //镜头拉远
    void CameraFieldFar()
    {
        m_camera.fieldOfView += Time.deltaTime * GameServices.configService.playerConfig.cameraFieldSpeed;
    }
    //镜头拉近
    void CameraFieldNear()
    {
        m_camera.fieldOfView -= Time.deltaTime * GameServices.configService.playerConfig.cameraFieldSpeed;
    }
}
