﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PropSelectUI : MonoBehaviour
{
    public GameObject m_strengthObj;
    public GameObject m_doubleObj;
    public GameObject m_coinObj;
    public GameObject m_strengthSymbolObj;
    public GameObject m_doubleSymbolObj;
    public GameObject m_coinSymbolObj;
    private void OnEnable()
    {
        int varCoin = LocalRecord.GetIntRecord(GlobalConfig.CoinReCordKey);
        m_strengthObj.SetActive(varCoin >= 10);
        m_doubleObj.SetActive(varCoin >= 20);
        m_coinObj.SetActive(varCoin >= 10);
        m_strengthSymbolObj.SetActive(false);
        m_doubleSymbolObj.SetActive(false);
        m_coinSymbolObj.SetActive(false);
    }
    //点击加强
    public void OnClickStrength()
    {
        BattleCtrl.instance.battleUI.SetBombStrength();
        BattleCtrl.instance.battleUI.SetCoin(-10);
        SetOpenState();
        m_strengthObj.SetActive(false);
        m_strengthSymbolObj.SetActive(true);
    }
    //点击double
    public void OnClickDouble()
    {
        BattleCtrl.instance.battleUI.SetBombDouble();
        BattleCtrl.instance.battleUI.SetCoin(-20);
        SetOpenState();
        m_doubleObj.SetActive(false);
        m_doubleSymbolObj.SetActive(true);
    }
    //点击金币
    public void OnClickCoin()
    {
        BattleCtrl.instance.battleUI.SetCoinDouble();
        BattleCtrl.instance.battleUI.SetCoin(-10);
        SetOpenState();
        m_coinObj.SetActive(false);
        m_coinSymbolObj.SetActive(true);
    }
    //开始
    public void OnClickStart()
    {
        gameObject.SetActive(false);
        Invoke("DelayHandle", 0.1f);
    }
    void DelayHandle()
    {
        BattleCtrl.instance.SelectPropState = false;
    }
    //设置open状态
    void SetOpenState()
    {
        int varCoin = LocalRecord.GetIntRecord(GlobalConfig.CoinReCordKey);
        if(m_strengthObj.activeSelf)
        {
            m_strengthObj.SetActive(varCoin >= 10);
        }
        if(m_doubleObj.activeSelf)
        {
            m_doubleObj.SetActive(varCoin >= 20);
        }
        if(m_coinObj.activeSelf)
        {
            m_coinObj.SetActive(varCoin >= 10);
        }
    }
}
