﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;
using System;

public class BattleUI : MonoBehaviour
{
    public Button m_dragBtn;
    public Button m_moveBtn;
    public Button m_restartBtn;
    public Button m_nextLevelBtn;
    public Button m_selectBtn;
    public Button m_tryAgain;//再来一次
    public Button m_startBtn;
    public Text m_levelText;
    public GameObject m_successObj;//胜利
    public GameObject m_selectLevelObj;//选择关卡节目
    public GameObject m_loseObj;//失败
    public GameObject m_startLogoObj;//开始Logo
    public Text m_gameBestTime;
    public Button m_posUpBtn;
    public Button m_posDownBtn;
    public Button m_fieldFarBtn;
    public Button m_fieldNearBtn;
    public Text m_cameraPosY;
    public Text m_cameraFieldView;
    public GameObject m_battleObj;//战斗UI
    public GameObject m_mouseObj;//手势UI
    public Text m_clawMoveSpeed;//爪子移动速度
    public Button m_settingBtn;//设置按钮
    public GameObject m_settingPanel;//设置界面
    public GameObject m_successResultObj;//胜利结算obj
    public GameObject m_successResultMaskObj;//胜利结算maskobj
    public GameObject m_ShowMouseObj;//显示手指图标obj
    public GameObject m_HideMouseObj;//隐藏手指图标obj
    public GameObject[] m_boomUIS;//爆炸Ui
    public Button m_boomBtn;//炸弹按钮
    public Transform m_starParent;//星级
    public Sprite m_fullStarSprite;//满星星
    public Sprite m_emptyStarSprite;//空星星
    public Color m_fullColor;//达到颜色
    public Color m_emptyColor;//没达到颜色
    public Image m_progress;//进度条
    public Text m_progressText;//进度条text
    public Text m_leftBombNum;//剩余炸弹数量
    public Image[] m_progressStar;//进度条星星
    public PropSelectUI m_propSelectUi;//道具选择ui
    public Text m_totalCoinText;//总的金币
    public Text m_levelCoinText;//通关金币
    public GameObject m_normalBombIcon;//普通炸弹图标
    public GameObject m_normalDoubleBombIcon;//double炸弹图标
    public GameObject m_strengthBombIcon;//加强炸弹图标
    public GameObject m_strengDoubleBombIcon;//加强double炸弹图标
    public Action onStartBtn;
    public Action onPosUpBtn;
    public Action onPosDownBtn;
    public Action onFieldFarBtn;
    public Action onFieldNearBtn;
    public Action onClawMoveSpeedAddBtn;
    public Action onClawMoveSpeedDownBtn;

    //private Text m_ShowOrHideMouseText;//显示或隐藏手指text
    private int m_mouseIndex = 0;//点击次数
    private bool m_bIsShowMouse = true;//是否显示手指图标
    private int m_bombIndex = 0;//炸弹计数
    private float m_textProgress = 0.0f;
    private float m_textProgressTotal = 0.0f;
    private float m_sliderProgress = 0.0f;
    private float m_sliderProgressTotal = 0.0f;

    private bool m_isBombStrength = false;
    private bool m_isBombDouble = false;
    private bool m_isCoinDouble = false;//是否结算金币double
    private int m_coin = 0;
    private bool m_bIsGameStart = false;//是否游戏开始
    public bool IsBombStrength { get { return m_isBombStrength; } }//是否加强了
    public bool IsBombDouble { get { return m_isBombDouble; } }//是否double
    public bool IsLeftEmtryBomb { get { return m_bombIndex >= 3; } }//是否不剩炸弹了
    public bool IsBombButtonCanInteractable { get { return m_boomBtn.interactable; } }
    void Awake()
    {
        m_dragBtn.onClick.AddListener(SetDragMode);
        m_moveBtn.onClick.AddListener(SetMoveMode);
        m_restartBtn.onClick.AddListener(LoadCurLevel);
        m_nextLevelBtn.onClick.AddListener(NextLevel);
        m_selectBtn.onClick.AddListener(SelectLevel);
        m_tryAgain.onClick.AddListener(TryAgainLevel);
        m_startBtn.onClick.AddListener(StartBtn);
        m_settingBtn.onClick.AddListener(SettingBtn);
        //m_posUpBtn.onClick.AddListener(PosUpBtn);
        //m_posDownBtn.onClick.AddListener(PosDownBtn);
        //m_fieldFarBtn.onClick.AddListener(FieldFarBtn);
        //m_fieldNearBtn.onClick.AddListener(FieldNearBtn);
        //m_ShowOrHideMouseText = m_ShowOrHideMouseObj.GetComponentInChildren<Text>();
        GameServices.audioServices.PlayBgm(GameServices.configService.audioConfig.GameBgm);
        GameServices.configService.playerConfig.ClawMoveSpeed = 0.4f;//开始默认值
    }
    private void Start()
    {
        m_boomBtn.interactable = false;
        if (LocalRecord.HasKey(GlobalConfig.CoinReCordKey))
        {
            m_coin = LocalRecord.GetIntRecord(GlobalConfig.CoinReCordKey);
        }
        m_totalCoinText.text = m_coin.ToString();
    }
    void SetDragMode()
    {
        BattleCtrl.instance.levelManager.curLevel.chainView.SetDragMode(true);
    }
    void SetMoveMode()
    {
        BattleCtrl.instance.levelManager.curLevel.chainView.SetDragMode(false);
    }
    // 当前关卡再来一次
    void LoadCurLevel()
    {
        m_loseObj.SetActive(false);
        m_successObj.SetActive(false);
        BattleCtrl.instance.levelManager.LoadCurLevel();
        //SceneManager.LoadScene(0);
    }
    //再来一次
    void TryAgainLevel()
    {
        m_loseObj.SetActive(false);
        BattleCtrl.instance.levelManager.LoadCurLevel();
    }
    // 进入下一关卡
    public void NextLevel()
    {
        m_successObj.SetActive(false);
        BattleCtrl.instance.levelManager.LoadNextLevel();
    }
    //选择关卡
    void SelectLevel()
    {
        m_loseObj.SetActive(false);
        m_successObj.SetActive(false);
        m_selectLevelObj.SetActive(true);
    }
    //开始游戏
    void StartBtn()
    {
        onStartBtn?.Invoke();
        m_startBtn.gameObject.SetActive(false);
        m_startLogoObj.SetActive(false);
        SetBattleObjState(true);
        SettingBtnState(false);
    }
    //设置
    void SettingBtn()
    {
        m_settingPanel.SetActive(!m_settingPanel.activeSelf);
    }
    //设置按钮状态
    public void SettingBtnState(bool bool_)
    {
        m_settingBtn.gameObject.SetActive(bool_);
    }
    //镜头拉上
    public void PosUpBtn()
    {
        onPosUpBtn?.Invoke();
        Camera varCam = Camera.main;
        if(varCam)
        {
            m_cameraPosY.text = string.Format("pos{0:f3}", varCam.transform.position.y);
        }
    }
    //镜头拉下
    public void PosDownBtn()
    {
        onPosDownBtn?.Invoke();
        Camera varCam = Camera.main;
        if (varCam)
        {
            m_cameraPosY.text = string.Format("pos{0:f3}", varCam.transform.position.y);
        }
    }
    //镜头拉远
    public void FieldFarBtn()
    {
        onFieldFarBtn?.Invoke();
        Camera varCam = Camera.main;
        if (varCam)
        {
            m_cameraFieldView.text = string.Format("fieldView{0:f1}", varCam.fieldOfView);
        }
    }
    //镜头拉近
    public void FieldNearBtn()
    {
        onFieldNearBtn?.Invoke();
        Camera varCam = Camera.main;
        if (varCam)
        {
            m_cameraFieldView.text = string.Format("fieldView{0:f1}", varCam.fieldOfView);
        }
    }
    //爪子移动速度增加
    public void ClawMoveSpeedAddBtn()
    {
        onClawMoveSpeedAddBtn?.Invoke();
        m_clawMoveSpeed.text = string.Format("系数越小，越快\n{0:f3}", GameServices.configService.playerConfig.ClawMoveSpeed);

    }
    //爪子移动速度减少
    public void ClawMoveSpeedDownBtn()
    {
        onClawMoveSpeedDownBtn?.Invoke();
        m_clawMoveSpeed.text = string.Format("系数越小，越快\n{0:f3}", GameServices.configService.playerConfig.ClawMoveSpeed);
    }
    //胜利
    public void OnBattleWin()
    {
        m_successObj.SetActive(true);
        m_selectLevelObj.SetActive(false);
        int varCurStar = BattleCtrl.instance.levelManager.curLevel.star;
        for (int i = 0; i < m_starParent.childCount; i++)
        {
            if(i < varCurStar)
            {
                m_starParent.GetChild(i).GetComponent<Image>().sprite = m_fullStarSprite;
            }
            else
            {
                m_starParent.GetChild(i).GetComponent<Image>().sprite = m_emptyStarSprite;
            }
        }
        //m_gameBestTime.text = string.Format("{0:d2}:{1:d2}", varCurTime / 60, varCurTime % 60);
        //string varKey = BattleCtrl.instance.levelManager.CurLevelIndex.ToString();
        //if (LocalRecord.HasKey(varKey))
        //{
        //    int varBestTime = LocalRecord.GetIntRecord(varKey);
        //    if (varCurTime < varBestTime)
        //    {
        //        m_gameBestTime.text = string.Format("{0:d2}:{1:d2}", varCurTime / 60, varCurTime % 60);
        //    }
        //    else
        //    {
        //        m_gameBestTime.text = string.Format("{0:d2}:{1:d2}", varBestTime / 60, varBestTime % 60);
        //    }
        //}
        //else
        //{
        //    m_gameBestTime.text = string.Format("{0:d2}:{1:d2}", varCurTime / 60, varCurTime % 60);
        //}
        //做法2
        //GameServices.audioServices.RecycleBgm();
        //GameServices.audioServices.PlayAudio(GameServices.configService.audioConfig.Success,false, delegate ()
        //{
        //    GameServices.audioServices.PlayBgm(GameServices.configService.audioConfig.GameBgm);
        //});
        //GameServices.audioServices.PlayAudio(GameServices.configService.audioConfig.Success);
        int varAddCoin = 0;
        if (m_textProgressTotal > 0.6f && m_textProgressTotal <= 0.7f)
        {
            varAddCoin = 5;
        }
        else if (m_textProgressTotal > 0.7f && m_textProgressTotal <= 0.8f)
        {
            varAddCoin = 10;
        }
        else
        {
            varAddCoin = 15;
        }
        if(m_isCoinDouble)
        {
            varAddCoin *= 2;
        }
        m_levelCoinText.text = string.Format("+{0:d}", varAddCoin);
        SetCoin(varAddCoin);
    }
    //失败
    public void OnBattleFail()
    {
        m_loseObj.SetActive(true);
        m_selectLevelObj.SetActive(false);
        //做法2
        //GameServices.audioServices.RecycleBgm();
        //GameServices.audioServices.PlayAudio(GameServices.configService.audioConfig.GetFail(),false, delegate ()
        //{
        //    GameServices.audioServices.PlayBgm(GameServices.configService.audioConfig.GameBgm);
        //});
        //GameServices.audioServices.PlayAudio(GameServices.configService.audioConfig.GetFail());
    }
    /// 加载关卡前调用，隐藏不需要显示的ui
    public void OnBeforeLoadLevel()
    {
        m_selectLevelObj.SetActive(false);
        m_successObj.SetActive(false);
    }

    /// 加载关卡后调用
    public void OnAfterLoadLevel()
    {
        //重置状态
        m_bombIndex = 0;
        //for(int i = 0;i<m_boomUIS.Length;i++)
        //{
        //    m_boomUIS[i].SetActive(true);
        //}
        m_boomBtn.interactable = false;
        m_leftBombNum.text = "X3";
        m_progressText.text = "0%";
        m_progress.fillAmount = 0;
        for (int i = 0; i < m_progressStar.Length; i++)
        {
            m_progressStar[i].color = m_emptyColor;
        }
        m_textProgress = 0.0f;
        m_textProgressTotal = 0.0f;
        m_sliderProgress = 0.0f;
        m_sliderProgressTotal = 0.0f;
        m_isBombStrength = false;
        m_isBombDouble = false;
        m_isCoinDouble = false;
        m_normalBombIcon.SetActive(true);
        m_normalDoubleBombIcon.SetActive(false);
        m_strengthBombIcon.SetActive(false);
        m_strengDoubleBombIcon.SetActive(false);
        CancelBomb();

        m_levelText.text = string.Format("Level {0:D}", BattleCtrl.instance.levelManager.CurLevelIndex + 1);

        Camera varCam = BattleCtrl.instance.levelManager.curLevel.cam;
        if (varCam)
        {
            m_cameraPosY.text = string.Format("pos{0:f3}", varCam.transform.position.y);
            m_cameraFieldView.text = string.Format("fieldView{0:f1}", varCam.fieldOfView);
        }
        GameServices.timerServices.Push(this, 1, delegate
        {
            m_clawMoveSpeed.text = string.Format("系数越小，越快\n{0:f3}", GameServices.configService.playerConfig.ClawMoveSpeed);
        });
        if(!m_bIsGameStart)
        {
            m_bIsGameStart = true;
        }
        else
        {
            m_propSelectUi.gameObject.SetActive(true);
            BattleCtrl.instance.SelectPropState = true;
        }
    }
    //设置战斗UI状态
    public void SetBattleObjState(bool bool_)
    {
        m_battleObj.SetActive(bool_);
        //m_successResultObj.SetActive(bool_);
        //m_successResultMaskObj.SetActive(!bool_);
        //m_ShowMouseObj.SetActive(!bool_);
        //m_HideMouseObj.SetActive(!bool_);
    }
    //设置手势位置
    public void SetMousePos(float x,float y)
    {
        m_mouseObj.SetActive((x != 0 || y != 0) && !m_battleObj.activeSelf && m_bIsShowMouse);
        Vector2 varVec2 = m_mouseObj.transform.localPosition;
        varVec2.x = x;
        varVec2.y = y;
        m_mouseObj.transform.localPosition = varVec2;
    }
    //显示手指图标
    public void ShowMouseBtn()
    {
        m_ShowMouseObj.SetActive(false);
        m_HideMouseObj.SetActive(false);
        m_bIsShowMouse = true;
        //m_mouseIndex++;
        //m_ShowOrHideMouseText.text = m_mouseIndex % 2 != 0 ? "show" : "hide";
    }
    public void HideMouseBtn()
    {
        m_ShowMouseObj.SetActive(false);
        m_HideMouseObj.SetActive(false);
        m_bIsShowMouse = false;
    }
    //设置炸弹
    public void SetBomb()
    {
        if (m_bombIndex >= 3)
            return;

        m_boomBtn.interactable = true;

        //m_boomUIS[m_bombIndex].SetActive(false);
        m_bombIndex++;
        m_leftBombNum.text = string.Format("X{0:d}", 3 - m_bombIndex);
        if(m_isBombDouble)
        {
            Invoke("OnClickBoomBtn", 3.4f);
        }
        else
        {
            Invoke("OnClickBoomBtn", 1.5f);
        }
    }
    void CancelBomb()
    {
        if(IsInvoking("OnClickBoomBtn"))
        {
            CancelInvoke("OnClickBoomBtn");
        }
    }

    //点击爆破按钮
    public void OnClickBoomBtn()
    {
        BattleCtrl.instance.levelManager.curLevel.bombView.StartBomb();
        m_boomBtn.interactable = false;
        BattleCtrl.instance.levelManager.curLevel.bombView.SetPlaceState(m_bombIndex < 3);
    }
    //设置进度
    public void SetProgress(float progress)
    {
        m_textProgressTotal = progress;
        if(progress >= 0 && progress <= 0.6f)
        {
            m_sliderProgressTotal = 0.25f * progress / 0.6f;
        }
        else if(progress > 0.6f && progress <= 0.7f)
        {
            m_sliderProgressTotal = 0.25f + 0.25f * (progress - 0.6f) * 10;
        }
        else if (progress > 0.7f && progress <= 0.8f)
        {
            m_sliderProgressTotal = 0.5f + 0.25f * (progress - 0.7f) * 10;
        }
        else
        {
            m_sliderProgressTotal = 0.75f + 0.25f * (progress - 0.8f) * 5;
        }
        for(int i = 0;i<m_progressStar.Length;i++)
        {
            m_progressStar[i].color = (progress >= 0.6f + 0.1f * i) ? m_fullColor : m_emptyColor;
        }
    }
    private void Update()
    {
        if (m_textProgress < m_textProgressTotal)
        {
            m_textProgress += Time.deltaTime;
            m_progressText.text = string.Format("{0:D}%", (int)(m_textProgress * 100));
        }
        else
        {
            m_progressText.text = string.Format("{0:D}%", (int)(m_textProgressTotal * 100));
        }
        if(m_sliderProgress < m_sliderProgressTotal)
        {
            m_sliderProgress += Time.deltaTime;
            m_progress.fillAmount = m_sliderProgress;
        }
    }
    //------------------关卡选择炸弹---------------------start
    //点击加强
    public void SetBombStrength()
    {
        HideBombIcon();
        if (m_isBombDouble)
        {
            m_strengDoubleBombIcon.SetActive(true);
        }
        else
        {
            m_strengthBombIcon.SetActive(true);
        }
        m_isBombStrength = true;
    }
    //点击double
    public void SetBombDouble()
    {
        HideBombIcon();
        if (m_isBombStrength)
        {
            m_strengDoubleBombIcon.SetActive(true);
        }
        else
        {
            m_normalDoubleBombIcon.SetActive(true);
        }
        m_isBombDouble = true;
    }
    //点击金币double
    public void SetCoinDouble()
    {
        m_isCoinDouble = true;
    }
    //隐藏所有炸弹图标
    void HideBombIcon()
    {
        m_normalBombIcon.SetActive(false);
        m_normalDoubleBombIcon.SetActive(false);
        m_strengthBombIcon.SetActive(false);
        m_strengDoubleBombIcon.SetActive(false);
    }
    //------------------关卡选择炸弹---------------------end
    //设置金币数量
    public void SetCoin(int coin)
    {
        m_coin += coin;
        LocalRecord.SetIntRecord(GlobalConfig.CoinReCordKey,m_coin);
        m_totalCoinText.text = m_coin.ToString();
    }
}
