﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using RayFire;
//using EzySlice;

public class BombView : MonoBehaviour
{
    public Transform m_cameraTrans;//相机
    public Transform m_rootTrans;//root节点
    public Transform m_propPosParent;//道具位置父节点
    public LineRenderer lineRenderer;//线段渲染器  
    public GameObject m_normalObj;//普通对象
    public GameObject m_cutOffObj;//切割对象
    public Material crossMaterial;
    public LayerMask layerMask;
    //public GameObject m_bombParticleObj;//炸弹粒子

    private RayfireBomb m_curBomb;//当前的炸弹
    //private BombState1View m_bombStateView;//控制炸弹状态
    private GameObject m_curBombEffect;//当前炸弹特效
    private bool m_bCanBePlace = true;//是否能放置炸弹
    private int m_totalChildNum = 0;//总数
    private bool m_bControlWin = true;//控制成功
    private bool m_bControlFail = true;//控制失败
    private float m_rate = 0.4f;//百分比
    private float m_rotateSpeed = 10.0f;//旋转速度
    private float m_curRotateAngle = 0.0f;//当前旋转角度
    private float m_lastRotateAngle = 0.0f;//之前的旋转角度
    private int m_TotalDamageNum = 0;//破坏数量
    private List<Transform> m_lstDamage = new List<Transform>();
    private Vector3 v0 = new Vector3(1.0f, 0.0f, 0.0f);
    private Vector3 v1 = new Vector3(0.0f, 1.0f, 0.0f);
    private int m_lineIndex = 0;//线计数
    private Vector2 m_lastInputPos = Vector2.zero;
    private Vector3 m_firstBombPos;//第一个炸弹位置
    private Vector3 m_secondBombPos;//第二个炸弹位置
    private bool m_bControlDoubleBomb = false;//控制第二个炸弹的位置
    private Vector3 m_recordSecondBombPos;//位置记录

    private Transform[] m_propStartPos;
    private GameObject m_curPropModelObj;

    private Animator m_curPropAnimator;
    private List<Vector3> m_pathPos = new List<Vector3>();//记录滑动路径点
    private int m_curPathIndex = 0;
    private bool m_bMouseUpEnd = false;
    private Vector3 m_hitPoint = Vector3.zero;
    private Vector3 m_lerpPos = Vector3.zero;
    private int m_curModelIndex = 0;
    private bool m_bLerp = false;
    private bool m_bIsFinishAni = true;
    private int m_mouseUpIndex = 0;
    private float m_totalCutOffNum = 15;//总的切割碎块
    private float m_curCutOffNum = 0;//当前切割碎块
    private bool m_bFinishCut = true;//完成切割
    private bool m_bIsSelectPropFinish = false;//是否选完道具
    private RayfireBlade m_rayFireBlade;
    private Transform m_childCutTrans;
    private bool m_bDelayFinishCut = true;
    private Vector3[] m_levelOnekniftDefaultPos = new [] { new Vector3(10.62f, 7.55f, -2.5f), new Vector3(10.62f, 4.92f, 1.78f)
                                                ,new Vector3(10.62f, 3.52f, -1.66f),new Vector3(10.62f, 1.89f, 1.78f)};
    private Quaternion[] m_levelOnekniftDefaultRotate = new[] { Quaternion.Euler(45,0,80), Quaternion.Euler(135, 0, 90) 
                                                        , Quaternion.Euler(45,0,90)};
    //private Vector3[] m_levelTwokniftDefaultPos = new[] { new Vector3(6.77f, 6.71f, -5.2f), new Vector3(12.68f, 5.5f, -0.37f)
    //                                            ,new Vector3(7.2f, 4.75f, -5.0f),new Vector3(12.36f, 1.16f, 0.52f)};
    //private Quaternion[] m_levelTwokniftDefaultRotate = new[] { Quaternion.Euler(66,0,35), Quaternion.Euler(87, 0, 48)
    //                                                    , Quaternion.Euler(66,0,43)};
    private Vector3[] m_levelTwokniftDefaultPos = new[] { new Vector3(13.34f, 5.95f, -2.27f), new Vector3(13.34f, 4.42f, 1.35f)
                                                ,new Vector3(13.34f, 3.65f, -1.92f),new Vector3(13.34f, 2.27f, 1.19f)};
    private Quaternion[] m_levelTwokniftDefaultRotate = new[] { Quaternion.Euler(45,0,80), Quaternion.Euler(135, 0, 90)
                                                        , Quaternion.Euler(45,0,90)};
    //private Vector3[] m_lineDefaultPos = new[] { new Vector3(0.7f, 0.68f, -1.11f), new Vector3(10.62f, 4.92f, 1.78f)
    //                                            ,new Vector3(10.62f, 3.52f, -1.66f),new Vector3(10.62f, 1.89f, 1.78f)};
    //private Quaternion[] m_lineDefaultRotate = new[] { Quaternion.Euler(12,0,0), Quaternion.Euler(135, 0, 90)
    //                                                    , Quaternion.Euler(45,0,90)};
    private Vector3[] m_kniftDefaultPos;
    private Quaternion[] m_kniftDefaultRotate;
    private void Awake()
    {
        m_totalChildNum = m_rootTrans.childCount - 1;
        m_propStartPos = m_propPosParent.GetComponentsInChildren<Transform>();
        m_childCutTrans = m_cutOffObj.transform.GetChild(0);
    }
    private void Start()
    {
        GameServices.inputService.pad.onMoveVec3 += OnMove;
        if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        {
            m_kniftDefaultPos = m_levelOnekniftDefaultPos;
            m_kniftDefaultRotate = m_levelOnekniftDefaultRotate;
            m_totalCutOffNum = 10;
        }
        else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex)
        {
            m_kniftDefaultPos = m_levelOnekniftDefaultPos;
            m_kniftDefaultRotate = m_levelOnekniftDefaultRotate;
            m_totalCutOffNum = 10;
        }
        //else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelSixIndex)
        //{
        //    m_rate = 0.7f;
        //}
        //else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelThreeIndex)
        //{
        //    m_rate = 0.3f;
        //}
        //else
        //{
        //    m_rate = 0.2f;
        //}
        lineRenderer.startWidth = 0.05f;
        lineRenderer.endWidth = 0.05f;
    }
    //道具1生成
    public void CreateProp1Model()
    {
        m_curModelIndex = 1;
        HideAllModel();
        m_curPropModelObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.prop1Obj);
        m_curPropAnimator = m_curPropModelObj.GetComponentInChildren<Animator>();
        PlayIdle();
        m_curPropModelObj.transform.localScale = Vector3.one * 0.7f;
        m_curPropModelObj.transform.position = m_propStartPos[1].position;
        SetNormalState(true);
        Invoke("InvokeCreateProp", 0.1f);
    }
    //道具2生成
    public void CreateProp2Model()
    {
        m_curModelIndex = 2;
        HideAllModel();
        m_curPropModelObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.prop2Obj);
        m_curPropAnimator = m_curPropModelObj.GetComponentInChildren<Animator>();
        PlayIdle();
        m_curPropModelObj.transform.position = m_propStartPos[2].position;
        SetNormalState(true);
        Invoke("InvokeCreateProp", 0.1f);
    }
    //道具3生成
    public void CreateProp3Model()
    {
        m_curModelIndex = 3;
        HideAllModel();
        m_curPropModelObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.prop3Obj);
        m_curPropAnimator = m_curPropModelObj.GetComponentInChildren<Animator>();
        PlayIdle();
        m_curPropModelObj.transform.localScale = Vector3.one * 0.7f;
        m_curPropModelObj.transform.position = m_propStartPos[3].position;
        SetNormalState(true);
        Invoke("InvokeCreateProp", 0.1f);
    }
    //道具4生成
    public void CreateProp4Model()
    {
        m_curModelIndex = 4;
        HideAllModel();
        m_curPropModelObj = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.prop4Obj);
        m_curPropModelObj.transform.position = m_propStartPos[4].position;
        m_curPropModelObj.transform.rotation = Quaternion.identity;
        SetNormalState(false);
        m_rayFireBlade = m_curPropModelObj.transform.Find("Props4/Props4/Blade_Target").GetComponent<RayfireBlade>();
        //m_rayFireBlade.SetTarget(m_childCutTrans.gameObject);
        Invoke("InvokeCreateProp", 0.1f);
    }
    void InvokeCreateProp()
    {
        m_bIsSelectPropFinish = true;
    }
    //设置普通对象状态
    void SetNormalState(bool value)
    {
        m_normalObj.SetActive(value);
        m_cutOffObj.SetActive(!value);
    }
    void PlayAnim(int value, string argName = "Value")
    {
        if (m_curPropAnimator && m_curPropAnimator.GetInteger(argName) != value)
        {
            m_curPropAnimator.SetInteger(argName, value);
        }
    }
    //播放待机动画
    void PlayIdle()
    {
        PlayAnim(0);
    }
    //播放攻击动画
    void PlayAttackAnimator()
    {
        Vector3 varPos = m_curPropModelObj.transform.position;
        if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        {
            if (m_curModelIndex == 3)
            {
                m_lerpPos.x = varPos.x - 1.5f;
            }
            else
            {
                m_lerpPos.x = m_hitPoint.x + 6.0f;
            }
        }
        else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex)
        {
            if (m_curModelIndex == 3)
            {
                m_lerpPos.x = varPos.x - 1.5f;
            }
            else
            {
                m_lerpPos.x = m_hitPoint.x + 6.0f;
            }
        }
        //m_lerpPos.x = varPos.x - 3.0f;
        m_lerpPos.y = m_hitPoint.y;
        //if (m_curModelIndex == 1)
        //{
        //}
        //else if(m_curModelIndex == 2)
        //{

        //}
        //else if (m_curModelIndex == 3)
        //{
        //    varPos.y = m_hitPoint.y - 2.0f;
        //}
        if (m_curModelIndex == 1)
        {
            m_lerpPos.z = varPos.z + m_hitPoint.z+0.7f;
        }   
        else
        {
            m_lerpPos.z = varPos.z + m_hitPoint.z;
        }
        m_bLerp = true;
        m_bIsFinishAni = false;
        float varWaitTime = 1.0f;
        if(m_curModelIndex == 2)
        {
            varWaitTime = 1.0f;
        }
        GameServices.timerServices.Push(this, 0.2f, delegate
        {
            m_bLerp = false;
            PlayAnim(1);
            GameServices.timerServices.Push(this, varWaitTime, delegate
            {
                PlayIdle();
            });
            GameServices.timerServices.Push(this, varWaitTime + 1.0f, delegate
            {
                if (m_curPropModelObj)
                {
                    m_bLerp = true;
                    m_bIsFinishAni = true;
                    if (m_curModelIndex == 1 || m_curModelIndex == 3)
                    {
                        m_curPropModelObj.transform.localScale = Vector3.one * 0.7f;
                    }
                    m_lerpPos = m_propStartPos[m_curModelIndex].position;
                }
            });
        });
    }
    //模型位置插值
    void UpdateModelPosLerp()
    {
        if (m_curPropModelObj && m_bLerp)
        {
            m_curPropModelObj.transform.position = Vector3.Lerp(m_curPropModelObj.transform.position, m_lerpPos, 0.5f);
        }
    }
    //隐藏模型
    void HideAllModel()
    {
        if (m_curPropModelObj)
        {
            PoolManager.Instance.ReturnObjectToPool(m_curPropModelObj);
        }
    }
    //移动
    void OnMove(Vector3 dir)
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        //m_curRotateAngle = m_cameraTrans.localEulerAngles.y;
        //m_curRotateAngle -= dir.x * Time.deltaTime* m_rotateSpeed;
        //m_cameraTrans.localRotation = Quaternion.Euler(0, m_curRotateAngle, 0);
    }
    //设置炸弹
    void SetBomb(RayfireBomb go)
    {
        //if(m_bombParticleObj)
        //{
        //    m_bombParticleObj.SetActive(false);
        //}

        m_curBomb = go;
        //m_bombStateView = go.GetComponent<BombState1View>();
        //m_bombStateView.SetBombModel();
        //if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        //{
        //    m_curBomb.range = 0.5f;
        //}
        //else if(BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex)
        //{
        //    m_curBomb.range = 1.5f;
        //}
        //m_bCanBePlace = false;
    }
    //播放动画
    public void PlayBombAni()
    {
        //if(m_bombStateView)
        //{
        //    m_bombStateView.PlayBombAni();
        //}
        BattleCtrl.instance.battleUI.OnClickBoomBtn();
        if(m_curModelIndex != 4)
        {
            PlayAttackAnimator();
        }
    }
    //画线
    void DrawLine()
    {
        float varDis = Vector3.Distance(m_firstBombPos, m_secondBombPos);
        Vector3 varDir = (m_secondBombPos - m_firstBombPos).normalized;
        //lineRenderer.positionCount = m_lineIndex + 1;
        //lineRenderer.SetPosition(m_lineIndex, m_firstBombPos + varDir * m_lineIndex * (varDis / 4.0f));

        m_lineIndex++;
        if (m_lineIndex >= 5)
        {
            m_lineIndex = 0;
            CancelInvoke("DrawLine");
        }
    }
    //设置放置状态
    public void SetPlaceState(bool value)
    {
        m_bCanBePlace = value;
    }
    //开始炸
    public void StartBomb()
    {
        //m_curBombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
        //m_curBombEffect.transform.position = m_curBomb.transform.position;
        //m_curBomb?.Explode(0);
        ////m_bombStateView.StartBomb();
        //m_curBomb.gameObject.SetActive(false);
        ////lineRenderer.positionCount = 0;
        ////回收
        ////m_bombStateView.ClearState();
        //PoolManager.Instance.ReturnObjectToPool(m_curBomb.gameObject);
        //m_curBomb = null;
        //GameServices.timerServices.Push(this, 1.0f, delegate
        //{
        //    if(m_curBombEffect)
        //    {
        //        PoolManager.Instance.ReturnObjectToPool(m_curBombEffect);
        //        m_curBombEffect = null;
        //    }
        //});
        if(m_curPropModelObj)
        {
            m_curPropModelObj.transform.localScale = Vector3.one;
        }
        if (m_curModelIndex == 4)
        {
            InvokeRepeating("CalculateCutOffNum", 0.3f, 0.1f);
        }
        else
        {
            InvokeRepeating("CalculateDamageNum", 0.3f, 0.1f);
        }
    }
    void CalculateDamageNum()
    {
        if (m_rootTrans)
        {
            for (int i = 1; i < m_rootTrans.childCount; i++)
            {
                Transform varTrans = m_rootTrans.GetChild(i);
                if (varTrans && varTrans.GetComponent<Rigidbody>() &&
                    varTrans.GetComponent<Rigidbody>().useGravity && !m_lstDamage.Contains(varTrans))
                {
                    m_TotalDamageNum++;
                    m_lstDamage.Add(varTrans);
                }
            }
        }
    }
    //计算当前切割的碎块数量
    void CalculateCutOffNum()
    {
        if (m_cutOffObj)
        {
            Transform[] varChild = m_cutOffObj.GetComponentsInChildren<Transform>();
            for (int i = 1; i < varChild.Length; i++)
            {
                Transform varTrans = varChild[i];
                if (varTrans && varTrans.gameObject.activeSelf && 
                    varTrans.GetComponent<Rigidbody>() && !m_lstDamage.Contains(varTrans))
                {
                    m_curCutOffNum++;
                    //Debug.LogError(m_curCutOffNum);
                    m_lstDamage.Add(varTrans);
                }
            }
        }
    }
    private void OnDestroy()
    {
        //if(m_bombStateView)
        //{
        //    m_bombStateView.ClearState();
        //}
        HideAllModel();
        m_curPropModelObj = null;
        m_curPropAnimator = null;
        if (m_curBomb)
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBomb.gameObject);
            m_curBomb = null;
        }
        if (m_curBombEffect)
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBombEffect);
            m_curBombEffect = null;
        }
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onMoveVec3 -= OnMove;
        }
        if(IsInvoking("CalculateDamageNum"))
        {
            CancelInvoke("CalculateDamageNum");
        }
        if (IsInvoking("CalculateCutOffNum"))
        {
            CancelInvoke("CalculateCutOffNum");
        }
        if (IsInvoking("DrawLine"))
        {
            CancelInvoke("DrawLine");
        }
        if (IsInvoking("TimeLimitStartBomb"))
        {
            CancelInvoke("TimeLimitStartBomb");
        }
        m_lstDamage.Clear();
        m_lstDamage = null;
    }
    //void Slice()
    //{
    //    Collider[] hits = Physics.OverlapBox(m_rayFireBlade.transform.position, new Vector3(5, 0.1f, 5), m_rayFireBlade.transform.rotation, layerMask);
    //    Debug.LogError(hits.Length);
    //    if (hits.Length <= 0)
    //        return;

    //    for (int i = 0; i < hits.Length; i++)
    //    {
    //        //SlicedHull hull = SliceObject(hits[i].gameObject, crossMaterial);
    //        SlicedHull hull = SliceObject(hits[i].gameObject);
    //        if (hull != null)
    //        {
    //            GameObject bottom = hull.CreateLowerHull(hits[i].gameObject, crossMaterial);
    //            GameObject top = hull.CreateUpperHull(hits[i].gameObject, crossMaterial);
    //            AddHullComponents(bottom);
    //            AddHullComponents(top);
    //            Destroy(hits[i].gameObject);
    //        }
    //    }
    //}

    //void AddHullComponents(GameObject go)
    //{
    //    go.layer = 9;
    //    Rigidbody rb = go.AddComponent<Rigidbody>();
    //    rb.interpolation = RigidbodyInterpolation.Interpolate;
    //    MeshCollider collider = go.AddComponent<MeshCollider>();
    //    collider.convex = true;

    //    rb.AddExplosionForce(100, go.transform.position, 20);
    //}

    //SlicedHull SliceObject(GameObject obj, Material crossSectionMaterial = null)
    //{
    //    // slice the provided object using the transforms of this object
    //    if (obj.GetComponent<MeshFilter>() == null)
    //        return null;

    //    return obj.Slice(m_rayFireBlade.transform.position, m_rayFireBlade.transform.up, crossSectionMaterial);
    //}
    //刀处理
    void UpdateKniftHandle()
    {
        if(m_curModelIndex != 4)
        {
            return;
        }
        if (m_bFinishCut/* && m_bDelayFinishCut*/)
        {
            if (Input.GetMouseButtonDown(0))
            {
                m_bMouseUpEnd = false;
                m_pathPos.Add(Input.mousePosition);
            }
            if (Input.GetMouseButton(0))
            {
                m_pathPos.Add(Input.mousePosition);
            }
            if (Input.GetMouseButtonUp(0))
            {
                if (m_pathPos.Count > 5 && (m_mouseUpIndex < m_kniftDefaultPos.Length - 1))
                {
                    m_bFinishCut = false;
                    m_bMouseUpEnd = true;
                    BattleCtrl.instance.battleUI.SetBomb();
                    //lineRenderer.transform.position = m_lineDefaultPos[0];
                    //lineRenderer.transform.rotation = m_lineDefaultRotate[0];
                    m_firstBombPos = m_kniftDefaultPos[m_mouseUpIndex];
                    m_secondBombPos = m_kniftDefaultPos[m_mouseUpIndex + 1];
                    m_mouseUpIndex += 1;
                }
            }
        }
        //画线
        if (m_bMouseUpEnd)
        {
            float varDis = Vector3.Distance(m_firstBombPos, m_secondBombPos);
            Vector3 varDir = (m_secondBombPos - m_firstBombPos).normalized;
            lineRenderer.positionCount = m_lineIndex + 1;
            lineRenderer.SetPosition(m_lineIndex, m_firstBombPos + varDir * m_lineIndex * (varDis / 4.0f));

            m_lineIndex++;
            if (m_lineIndex >= 5)
            {
                m_lineIndex = 0;
                m_bMouseUpEnd = false;
                //m_bDelayFinishCut = false;
                m_pathPos.Clear();
                m_curPropModelObj.transform.position = m_firstBombPos;
                m_curPropModelObj.transform.rotation = m_kniftDefaultRotate[m_mouseUpIndex - 1];
            }
        }
        //画完线开始切割
        if(m_lineIndex == 0 && m_mouseUpIndex > 0 && m_curPropModelObj && !m_bFinishCut/* && !m_bDelayFinishCut*/)
        {
            m_curPropModelObj.transform.position = Vector3.Lerp(m_curPropModelObj.transform.position, m_secondBombPos,0.2f);

            //Slice();
            if (Vector3.SqrMagnitude(m_curPropModelObj.transform.position - m_secondBombPos) <= 0.5f)
            {
                lineRenderer.positionCount = 0;
                m_bFinishCut = true;
                m_rayFireBlade.SliceTarget();
                GameServices.timerServices.Push(this, 2.0f, delegate
                {
                    if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
                    {
                        if (m_mouseUpIndex == 1)
                        {
                            m_childCutTrans = m_cutOffObj.transform.Find("column_root/column_fr_0");
                        }
                        else if (m_mouseUpIndex == 2)
                        {
                            m_childCutTrans = m_cutOffObj.transform.Find("column_root/column_fr_0_root/column_fr_0_fr_0");
                        }
                    }
                    else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex)
                    {
                        if (m_mouseUpIndex == 1)
                        {
                            m_childCutTrans = m_cutOffObj.transform.Find("people_root/people_fr_0");
                        }
                        else if (m_mouseUpIndex == 2)
                        {
                            m_childCutTrans = m_cutOffObj.transform.Find("people_root/people_fr_0_root/people_fr_0_fr_0");
                        }
                    }
                    if (m_childCutTrans)
                    {
                        m_bDelayFinishCut = true;
                        m_rayFireBlade.SetTarget(m_childCutTrans.gameObject);
                    }
                });
            }
        }
        //if (Input.GetMouseButtonDown(0))
        //{
        //    m_bMouseUpEnd = false;
        //    m_pathPos.Add(Input.mousePosition);
        //}
        //if (Input.GetMouseButton(0))
        //{
        //    m_pathPos.Add(Input.mousePosition);
        //}
        //if (Input.GetMouseButtonUp(0))
        //{
        //    m_pathPos.Add(Input.mousePosition);
        //    m_bMouseUpEnd = true;
        //    if (m_curPropModelObj && m_curModelIndex == 4)
        //    {
        //        if (m_pathPos.Count > 0)
        //        {
        //            Vector3 pos = Camera.main.WorldToScreenPoint(m_curPropModelObj.transform.position);//将对象坐标换成屏幕坐标
        //            Vector3 mousePos = new Vector3(m_pathPos[0].x, m_pathPos[0].y, pos.z);//让鼠标的屏幕坐标与对象坐标一致
        //            Vector3 modelPos = Camera.main.ScreenToWorldPoint(mousePos);
        //            m_curPropModelObj.transform.position = modelPos;
        //        }
        //        m_curPropModelObj.SetActive(true);
        //    }
        //}
        //if (m_bMouseUpEnd && m_curPropModelObj && m_curModelIndex == 4)
        //{
        //    Vector3 pos = Camera.main.WorldToScreenPoint(m_curPropModelObj.transform.position);//将对象坐标换成屏幕坐标
        //    Vector3 mousePos = new Vector3(m_pathPos[m_curPathIndex].x, m_pathPos[m_curPathIndex].y, pos.z);//让鼠标的屏幕坐标与对象坐标一致
        //    Vector3 modelPos = Camera.main.ScreenToWorldPoint(mousePos);
        //    modelPos.x = 7.0f;
        //    modelPos.y -= 2.5f;
        //    Vector3 targetDir = (modelPos - m_curPropModelObj.transform.position).normalized;
        //    if (!targetDir.Equals(Vector3.zero))
        //    {
        //        Quaternion targetRotation = Quaternion.LookRotation(targetDir, Vector3.up);
        //        m_curPropModelObj.transform.rotation = Quaternion.Lerp(m_curPropModelObj.transform.rotation, targetRotation, 0.2f);
        //    }

        //    //m_curPropModelObj.transform.position = modelPos;
        //    m_curPropModelObj.transform.position = Vector3.Lerp(m_curPropModelObj.transform.position, modelPos, 0.2f);
        //    m_curPathIndex++;
        //    if (m_curPathIndex >= m_pathPos.Count)
        //    {
        //        m_bMouseUpEnd = false;
        //        m_curPathIndex = 0;
        //        m_pathPos.Clear();
        //        m_curPropModelObj.SetActive(false);
        //        m_curPropModelObj.transform.position = m_propStartPos[4].position;
        //    }
        //}
    }
    private void Update()
    {
        UpdateModelPosLerp();
        if (!BattleCtrl.instance.isStartBattle || BattleCtrl.instance.isEndBattle
            || BattleCtrl.instance.battleUI.IsActivitySelectLevelUi || !m_bIsSelectPropFinish)
        {
            return;
        }
        if (Input.GetMouseButton(0))
        {
            float varX = (Input.mousePosition.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth) + 100.0f;
            float varY = (Input.mousePosition.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth) - 120.0f;
            BattleCtrl.instance.battleUI.SetMousePos(varX, varY);
        }
        if (Input.GetMouseButtonUp(0))
        {
            BattleCtrl.instance.battleUI.SetMousePos(0, 0);
            if (m_lastRotateAngle == m_curRotateAngle)
            {
                Clicked();
            }
            m_lastRotateAngle = m_curRotateAngle;
        }
        if(m_curModelIndex == 4)
        {
            BattleCtrl.instance.battleUI.SetProgress(m_curCutOffNum / m_totalCutOffNum);
        }
        else
        {
            BattleCtrl.instance.battleUI.SetProgress(m_TotalDamageNum / (float)m_totalChildNum);
        }
        //Debug.LogError((m_rootTrans.childCount - 1) + "................." + m_totalChildNum);
        if(m_bControlWin)
        {
            if (BattleCtrl.instance.battleUI.IsLeftEmtryBomb && !BattleCtrl.instance.battleUI.IsBombButtonCanInteractable)
            {
                m_bControlWin = false;
                Invoke("CheckSuccess", 1);
            }
            if(m_curModelIndex == 4)
            {
                if (m_curCutOffNum / m_totalCutOffNum >= 0.8f)
                {
                    m_bControlWin = false;
                    BattleCtrl.instance.levelManager.curLevel.star = 3;
                    BattleCtrl.instance.OnBattleWin();
                }
            }
            else
            {
                if ((float)m_TotalDamageNum / m_totalChildNum >= 0.8f)
                {
                    m_bControlWin = false;
                    BattleCtrl.instance.levelManager.curLevel.star = 3;
                    BattleCtrl.instance.OnBattleWin();
                }
            }
        }
        //if(m_rootTrans.childCount <= m_totalChildNum* m_rate && m_bControlWin)
        //{
        //    m_bControlWin = false;
        //    BattleCtrl.instance.OnBattleWin();
        //}
        if (BattleCtrl.instance.battleUI.IsLeftEmtryBomb && !BattleCtrl.instance.battleUI.IsBombButtonCanInteractable
            && m_TotalDamageNum < m_totalChildNum * 0.6f && m_bControlFail)
        {
            m_bControlFail = false;
            Invoke("CheckFail", 4);
        }
        UpdateKniftHandle();
    }
    //检查胜利
    void CheckSuccess()
    {
        if(m_curModelIndex == 4)
        {
            if (m_curCutOffNum / m_totalCutOffNum >= 0.8f)
            {
                BattleCtrl.instance.levelManager.curLevel.star = 3;
                BattleCtrl.instance.OnBattleWin();
            }
            else if (m_curCutOffNum / m_totalCutOffNum < 0.8f && m_curCutOffNum / m_totalCutOffNum >= 0.7f)
            {
                BattleCtrl.instance.levelManager.curLevel.star = 2;
                BattleCtrl.instance.OnBattleWin();
            }
            else if (m_curCutOffNum / m_totalCutOffNum >= 0.6f && m_curCutOffNum / m_totalCutOffNum < 0.7f)
            {
                BattleCtrl.instance.levelManager.curLevel.star = 1;
                BattleCtrl.instance.OnBattleWin();
            }
        }
        else
        {
            if ((float)m_TotalDamageNum / m_totalChildNum >= 0.8f)
            {
                BattleCtrl.instance.levelManager.curLevel.star = 3;
                BattleCtrl.instance.OnBattleWin();
            }
            else if ((float)m_TotalDamageNum / m_totalChildNum < 0.8f && (float)m_TotalDamageNum / m_totalChildNum >= 0.7f)
            {
                BattleCtrl.instance.levelManager.curLevel.star = 2;
                BattleCtrl.instance.OnBattleWin();
            }
            else if ((float)m_TotalDamageNum / m_totalChildNum >= 0.6f && (float)m_TotalDamageNum / m_totalChildNum < 0.7f)
            {
                BattleCtrl.instance.levelManager.curLevel.star = 1;
                BattleCtrl.instance.OnBattleWin();
            }
        }
    }
    //检查是否失败
    void CheckFail()
    {
        if (BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        BattleCtrl.instance.OnBattleFail();
    }

    void Clicked()
    {
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider.tag == "Target" && m_bCanBePlace && m_curPropModelObj && m_bIsFinishAni
                && m_curModelIndex != 4)
            {
                BattleCtrl.instance.battleUI.SetSelectUIState(false);
                //一个炸弹的
                m_bCanBePlace = false;
                //GameObject go = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.rayfireBombObj);
                //go.transform.position = hit.point;
                //SetBomb(go.GetComponent<RayfireBomb>());
                ////m_bombStateView.SetBombModelPos(hit.point);
                ////m_lastInputPos = Input.mousePosition;
                ////Vector3 varVec3 = hit.point;
                ////varVec3.x += 0.1f;
                ////m_firstBombPos = varVec3;
                m_hitPoint = hit.point;
                BattleCtrl.instance.battleUI.SetBomb();
                //两个炸弹的
                //if (!m_bControlDoubleBomb)
                //{
                //    GameObject go = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.rayfireBombObj);
                //    //go.transform.position = hit.point;
                //    SetBomb(go);
                //    m_bombStateView.SetBombModelPos(hit.point);
                //    m_lastInputPos = Input.mousePosition;
                //    Vector3 varVec3 = hit.point;
                //    varVec3.x += 0.1f;
                //    m_firstBombPos = varVec3;
                //    //是否生成double
                //    if (BattleCtrl.instance.battleUI.IsBombDouble)
                //    {
                //        RandomCreateAnotherBomb();
                //        m_bControlDoubleBomb = true;
                //    }
                //    else
                //    {
                //        m_bCanBePlace = false;
                //        BattleCtrl.instance.battleUI.SetBomb();
                //    }
                //}
                //else
                //{
                //    m_bControlDoubleBomb = false;
                //    m_bCanBePlace = false;
                //    BattleCtrl.instance.battleUI.SetBomb();//指定位置后开始炸
                //    m_bombStateView.SetUnrealBombModelPos(hit.point);
                //    m_bombStateView.StartShaderChange();
                //    InvokeRepeating("DrawLine", 0.1f, 0.3f);
                //    Vector3 varPoint = hit.point;
                //    varPoint.x += 0.1f;
                //    m_secondBombPos = varPoint;
                //    //指定后要取消判定
                //    if(IsInvoking("TimeLimitStartBomb"))
                //    {
                //        CancelInvoke("TimeLimitStartBomb");
                //    }
                //}
            }
        }
    }
    //范围随机生成一个炸弹
    //void RandomCreateAnotherBomb()
    //{
    //    Vector3 varVec3;
    //    float varRanX = Random.Range(m_lastInputPos.x - 300.0f, m_lastInputPos.x + 300.0f);
    //    float varRanY = Random.Range(m_lastInputPos.y - 300.0f, m_lastInputPos.y + 300.0f);
    //    varVec3.x = varRanX;
    //    varVec3.y = varRanY;
    //    varVec3.z = Input.mousePosition.z;

    //    Ray ray = Camera.main.ScreenPointToRay(varVec3);

    //    RaycastHit hit = new RaycastHit();

    //    if (Physics.Raycast(ray, out hit))
    //    {
    //        if (hit.collider.tag == "Target" && m_bCanBePlace)
    //        {
    //            m_bombStateView.SetUnrealBombModelPos(hit.point);
    //            m_bombStateView.SetUnrealBombModel();
    //            m_recordSecondBombPos = hit.point;
    //            Invoke("TimeLimitStartBomb", 5.0f);
    //        }
    //        else
    //        {
    //            RandomCreateAnotherBomb();
    //        }
    //    }
    //    else
    //    {
    //        RandomCreateAnotherBomb();
    //    }
    //}
    ////过5秒自己开始炸,如果玩家没有指定位置
    //void TimeLimitStartBomb()
    //{
    //    m_bControlDoubleBomb = false;
    //    m_bCanBePlace = false;
    //    BattleCtrl.instance.battleUI.SetBomb();//指定位置后开始炸
    //    m_bombStateView.StartShaderChange();
    //    InvokeRepeating("DrawLine", 0.1f, 0.3f);
    //    Vector3 varPoint = m_recordSecondBombPos;
    //    varPoint.x += 0.1f;
    //    m_secondBombPos = varPoint;
    //}
}
