﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ChainDragView : MonoBehaviour
{
    public Transform m_topTrans;
    private float m_topPosY;
    private void Start()
    {
        m_topPosY = m_topTrans.position.y;
        GameServices.inputService.pad.onMoveVec3 += OnMove;
    }
    //移动
    void OnMove(Vector3 dir)
    {
        float varParamDis = Screen.width * 0.8f / 2;//参数距离
        Vector3 varPos = m_topTrans.position;
        //向左滑
        if (dir.x > 0)
        {
            varPos.x -= dir.x / varParamDis * GameServices.configService.playerConfig.xDirMaxDis;
        }
        //向右滑
        if (dir.x < 0)
        {
            varPos.x += dir.x / varParamDis * GameServices.configService.playerConfig.xDirMinDis;
        }
        //向上滑
        if (dir.y < 0)
        {
            varPos.z += dir.y / varParamDis * GameServices.configService.playerConfig.yDirMinDis;
        }
        //向下滑
        if (dir.y > 0)
        {
            varPos.z -= dir.y / varParamDis * GameServices.configService.playerConfig.yDirMaxDis;
        }
        varPos.y = m_topPosY;
        m_topTrans.position = varPos;
    }
    private void OnDestroy()
    {
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onMoveVec3 -= OnMove;
        }
    }
}
