﻿Shader "Custom/AlphaRimPro"
{
	Properties
	{
		_MainTex("Particle Texture", 2D) = "white" {}
		_RimColor("Rim Color", Color) = (0.5,0.5,0.5,0.5)
		_InnerColor("Inner Color", Color) = (0.5,0.5,0.5,0.5)
		_InnerColorPower("Inner Color Power", Range(0.0,1.0)) = 0.5
		_RimPower("Rim Power", Range(0.0,5.0)) = 2.5
		_AlphaPower("Alpha Rim Power", Range(0.0,10)) = 4.0
		_AllPower("All Power", Range(0.0, 10.0)) = 1.0
	}
		Category{
		Tags{ "Queue" = "Transparent" "IgnoreProjector" = "True" "RenderType" = "Effect" "PreviewType" = "Plane" }
 
		SubShader
	{
		Pass
	{
		Blend SrcAlpha  One
		Lighting Off ZWrite Off Fog{ Mode Off }
 
		CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_particles
#pragma fragmentoption ARB_precision_hint_fastest 
#include "UnityCG.cginc"
		sampler2D _MainTex;
	half4 _MainTex_ST;
	float4 _RimColor;
	float _RimPower;
	float _AlphaPower;
	float _AlphaMin;
	float _InnerColorPower;
	float _AllPower;
	float4 _InnerColor;
 
	struct v2f {
		half4 pos : SV_POSITION;
		half2 uv : TEXCOORD0;
		float4 posWorld : TEXCOORD1;
		float3 normalDir : TEXCOORD2;
		fixed4 vertexColor : COLOR;
	};
 
	v2f vert(appdata_full v) {
		v2f o;
 
		o.pos = UnityObjectToClipPos(v.vertex);
		o.uv = TRANSFORM_TEX(v.texcoord, _MainTex);
		o.vertexColor = v.color;
		o.posWorld = mul(unity_ObjectToWorld, v.vertex);
		o.normalDir = UnityObjectToWorldNormal(v.normal);
		return o;
	}
 
	float4 frag(v2f i) : COLOR
	{
		float4 color = tex2D(_MainTex, i.uv.xy);
		float3 viewDir = normalize(_WorldSpaceCameraPos.xyz - i.posWorld.xyz);
		half rim = 1.0 - saturate(dot(normalize(viewDir), i.normalDir));
		color.rgb = color.rgb + _RimColor.rgb * pow(rim, _RimPower) *_AllPower + (_InnerColor.rgb * 2 * _InnerColorPower);
		color.a = pow(rim, _AlphaPower) * (10 - _AlphaPower) * _RimColor.a / 10;
		return color;
	}
 
		ENDCG
	}
	}
	}
    FallBack "Diffuse"
}
