﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using RayFire;

public class BombView : MonoBehaviour
{
    public Transform m_cameraTrans;//相机
    public Transform m_rootTrans;//root节点
    public LineRenderer lineRenderer;//线段渲染器  
    //public GameObject m_bombParticleObj;//炸弹粒子

    private RayfireBomb m_curBomb;//当前的炸弹
    private BombStateView m_bombStateView;//控制炸弹状态
    private GameObject m_curBombEffect;//当前炸弹特效
    private bool m_bCanBePlace = true;//是否能放置炸弹
    private int m_totalChildNum = 0;//总数
    private bool m_bControlWin = true;//控制成功
    private bool m_bControlFail = true;//控制失败
    private float m_rate = 0.4f;//百分比
    private float m_rotateSpeed = 10.0f;//旋转速度
    private float m_curRotateAngle = 0.0f;//当前旋转角度
    private float m_lastRotateAngle = 0.0f;//之前的旋转角度
    private int m_TotalDamageNum = 0;//破坏数量
    private List<Transform> m_lstDamage = new List<Transform>();
    private Vector3 v0 = new Vector3(1.0f, 0.0f, 0.0f);
    private Vector3 v1 = new Vector3(0.0f, 1.0f, 0.0f);
    private int m_lineIndex = 0;//线计数
    private Vector2 m_lastInputPos = Vector2.zero;
    private void Awake()
    {
        m_totalChildNum = m_rootTrans.childCount - 1;
    }
    private void Start()
    {
        GameServices.inputService.pad.onMoveVec3 += OnMove;
        //if(BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelFourIndex)
        //{
        //    m_rate = 0.4f;
        //}
        //else if(BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelFiveIndex)
        //{
        //    m_rate = 0.5f;
        //}
        //else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelSixIndex)
        //{
        //    m_rate = 0.7f;
        //}
        //else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelThreeIndex)
        //{
        //    m_rate = 0.3f;
        //}
        //else
        //{
        //    m_rate = 0.2f;
        //}
        lineRenderer.startWidth = 0.02f;
        lineRenderer.endWidth = 0.02f;
    }
    //移动
    void OnMove(Vector3 dir)
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        m_curRotateAngle = m_cameraTrans.localEulerAngles.y;
        m_curRotateAngle -= dir.x * Time.deltaTime* m_rotateSpeed;
        m_cameraTrans.localRotation = Quaternion.Euler(0, m_curRotateAngle, 0);
    }
    //设置炸弹
    void SetBomb(RayfireBomb rayfireBomb)
    {
        //if(m_bombParticleObj)
        //{
        //    m_bombParticleObj.SetActive(false);
        //}

        m_curBomb = rayfireBomb;
        m_bombStateView = m_curBomb.GetComponent<BombStateView>();
        //if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        //{
        //    m_curBomb.range = 0.5f;
        //}
        //else if(BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex)
        //{
        //    m_curBomb.range = 1.5f;
        //}
        m_bCanBePlace = false;
        InvokeRepeating("DrawLine", 0.3f, 0.5f);
    }
    //画线
    void DrawLine()
    {
        lineRenderer.positionCount = m_lineIndex + 1;
        lineRenderer.SetPosition(m_lineIndex, m_curBomb.transform.position + -Vector3.forward * m_lineIndex/3.0f);

        m_lineIndex++;
        if (m_lineIndex >= 5)
        {
            CancelInvoke("DrawLine");
        }
    }
    //设置放置状态
    public void SetPlaceState(bool value)
    {
        m_bCanBePlace = value;
    }
    //开始炸
    public void StartBomb()
    {
        m_curBombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
        m_curBombEffect.transform.position = m_curBomb.transform.position;
        m_curBomb?.Explode(0);
        m_curBomb.gameObject.SetActive(false);
        //回收
        PoolManager.Instance.ReturnObjectToPool(m_curBomb.gameObject);
        GameServices.timerServices.Push(this, 1.0f, delegate
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBombEffect);
        });
        InvokeRepeating("CalculateDamageNum", 0.3f, 0.1f);
    }
    void CalculateDamageNum()
    {
        if (m_rootTrans)
        {
            for (int i = 1; i < m_rootTrans.childCount; i++)
            {
                Transform varTrans = m_rootTrans.GetChild(i);
                if (varTrans && varTrans.GetComponent<Rigidbody>() &&
                    varTrans.GetComponent<Rigidbody>().useGravity && !m_lstDamage.Contains(varTrans))
                {
                    m_TotalDamageNum++;
                    m_lstDamage.Add(varTrans);
                }
            }
        }
    }
    private void OnDestroy()
    {
        if(m_curBomb)
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBomb.gameObject);
        }
        if(m_curBombEffect)
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBombEffect);
        }
        if (GameServices.inputService != null)
        {
            GameServices.inputService.pad.onMoveVec3 -= OnMove;
        }
        if(IsInvoking("CalculateDamageNum"))
        {
            CancelInvoke("CalculateDamageNum");
        }
        if (IsInvoking("DrawLine"))
        {
            CancelInvoke("DrawLine");
        }
        m_lstDamage.Clear();
        m_lstDamage = null;
    }
    private void Update()
    {
        if (!BattleCtrl.instance.isStartBattle || BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        if (Input.GetMouseButtonUp(0))
        {
            if (m_lastRotateAngle == m_curRotateAngle)
            {
                Clicked();
            }
            m_lastRotateAngle = m_curRotateAngle;
        }
        BattleCtrl.instance.battleUI.SetProgress(m_TotalDamageNum / (float)m_totalChildNum);
        //Debug.LogError((m_rootTrans.childCount - 1) + "................." + m_totalChildNum);
        if(m_bControlWin)
        {
            if (BattleCtrl.instance.battleUI.IsLeftEmtryBomb && !BattleCtrl.instance.battleUI.IsBombButtonCanInteractable)
            {
                m_bControlWin = false;
                Invoke("CheckSuccess", 4);
            }
            if ((float)m_TotalDamageNum / m_totalChildNum >= 0.8f)
            {
                m_bControlWin = false;
                BattleCtrl.instance.levelManager.curLevel.star = 3;
                BattleCtrl.instance.OnBattleWin();
            }
        }
        //if(m_rootTrans.childCount <= m_totalChildNum* m_rate && m_bControlWin)
        //{
        //    m_bControlWin = false;
        //    BattleCtrl.instance.OnBattleWin();
        //}
        if (BattleCtrl.instance.battleUI.IsLeftEmtryBomb && !BattleCtrl.instance.battleUI.IsBombButtonCanInteractable
            && m_TotalDamageNum < m_totalChildNum * 0.6f && m_bControlFail)
        {
            m_bControlFail = false;
            Invoke("CheckFail", 4);
        }
    }
    //检查胜利
    void CheckSuccess()
    {
        if ((float)m_TotalDamageNum / m_totalChildNum >= 0.8f)
        {
            BattleCtrl.instance.levelManager.curLevel.star = 3;
            BattleCtrl.instance.OnBattleWin();
        }
        else if ((float)m_TotalDamageNum/ m_totalChildNum < 0.8f && (float)m_TotalDamageNum/ m_totalChildNum >= 0.7f)
        {
            BattleCtrl.instance.levelManager.curLevel.star = 2;
            BattleCtrl.instance.OnBattleWin();
        }
        else if ((float)m_TotalDamageNum / m_totalChildNum >= 0.6f && (float)m_TotalDamageNum/ m_totalChildNum < 0.7f)
        {
            BattleCtrl.instance.levelManager.curLevel.star = 1;
            BattleCtrl.instance.OnBattleWin();
        }
    }
    //检查是否失败
    void CheckFail()
    {
        if (BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        BattleCtrl.instance.OnBattleFail();
    }

    void Clicked()
    {
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider.tag == "Target" && m_bCanBePlace)
            {
                GameObject go = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.rayfireBombObj);
                go.transform.position = hit.point;
                SetBomb(go.GetComponent<RayfireBomb>());
                BattleCtrl.instance.battleUI.SetBomb();
                m_lastInputPos = Input.mousePosition;
            }
        }
    }
    //范围随机生成一个炸弹
    void RandomCreateAnotherBomb()
    {
        Vector3 varVec3;
        float varRanX = Random.Range(m_lastInputPos.x - 200.0f, m_lastInputPos.x + 200.0f);
        float varRanY = Random.Range(m_lastInputPos.y - 200.0f, m_lastInputPos.y + 200.0f);
        varVec3.x = varRanX;
        varVec3.y = varRanY;
        varVec3.z = 0;

        Ray ray = Camera.main.ScreenPointToRay(varVec3);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider.tag == "Target" && m_bCanBePlace)
            {
                GameObject go = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.rayfireBombObj);
                go.transform.position = hit.point;
                SetBomb(go.GetComponent<RayfireBomb>());
                BattleCtrl.instance.battleUI.SetBomb();
                m_lastInputPos = Input.mousePosition;
            }
        }
    }
}
