﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using RayFire;

public class BombView : MonoBehaviour
{
    public GameObject m_bombParticleObj;//炸弹粒子
    public GameObject m_bombEffectObj;//炸弹特效
    public RayfireBomb m_rayfireBomb;//炸弹预设

    private RayfireBomb m_curBomb;//当前的炸弹
    private GameObject m_curBombEffect;//当前炸弹特效
    private bool m_bCanBePlace = true;//是否能放置炸弹
    //设置炸弹
    void SetBomb(RayfireBomb rayfireBomb)
    {
        m_bombParticleObj?.SetActive(false);

        m_curBomb = rayfireBomb;
        m_bCanBePlace = false;
    }
    //设置放置状态
    public void SetPlaceState(bool value)
    {
        m_bCanBePlace = value;
    }
    //开始炸
    public void StartBomb()
    {
        m_curBombEffect = PoolManager.Instance.GetObjectFromPool(m_bombEffectObj);
        m_curBombEffect.transform.position = m_curBomb.transform.position;
        m_curBomb?.Explode(0);
        m_curBomb.gameObject.SetActive(false);
        //回收
        PoolManager.Instance.ReturnObjectToPool(m_curBomb.gameObject);
        GameServices.timerServices.Push(this, 1.0f, delegate
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBombEffect);
        });
    }
    private void OnDestroy()
    {
        if(m_curBomb)
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBomb.gameObject);
        }
        if(m_curBombEffect)
        {
            PoolManager.Instance.ReturnObjectToPool(m_curBombEffect);
        }
    }
    private void Update()
    {
        if (!BattleCtrl.instance.isStartBattle)
        {
            return;
        }
        if (Input.GetMouseButtonDown(0))
        {
            Clicked();
        }
    }

    void Clicked()
    {
        Ray ray = Camera.main.ScreenPointToRay(Input.mousePosition);

        RaycastHit hit = new RaycastHit();

        if (Physics.Raycast(ray, out hit))
        {
            if (hit.collider.tag == "Target" && m_bCanBePlace)
            {
                GameObject go = PoolManager.Instance.GetObjectFromPool(m_rayfireBomb.gameObject);
                go.transform.position = hit.point;
                SetBomb(go.GetComponent<RayfireBomb>());
                BattleCtrl.instance.battleUI.SetBomb();
            }
        }
    }
}
