﻿//关卡管理器,控制加载卸载关卡
using System;
using System.Collections.Generic;
using UnityEngine;

public class LevelManager : MonoBehaviour
{
    /// <summary>
    /// 关卡预设,TODO 之后改为根据预设路径加载
    /// </summary>
    public List<LevelCtrl> levelPrefs;

    LevelCtrl _CurLevel;
    public LevelCtrl curLevel => _CurLevel;

    LevelCtrl _LastLevel;

    /// <summary>
    /// 加载关卡前回调
    /// </summary>
    public OnDelegateArg0 onBeforeLoadLevel;

    /// <summary>
    /// 加载关卡后回调
    /// </summary>
    public OnDelegateArg0 onAfterLoadLevel;

    /// <summary>
    /// 当前处于第几关
    /// </summary>
    int _CurLevelIndex;
    public int CurLevelIndex => _CurLevelIndex;

    /// <summary>
    /// 加载指定关卡,TODO 之后改为动态加载关卡
    /// </summary>
    /// <param name="level">第几关</param>
    public LevelCtrl LoadLevel(int levelIndex)
    {
        if (levelIndex >= 0 && levelIndex < levelPrefs.Count)
        {
            //加载新关卡
            for (int i = 0; i < levelPrefs.Count; ++i)
            {
                if (levelPrefs[i].curLevelIndex == levelIndex)//是需要加载的关卡
                {
                    onBeforeLoadLevel?.Invoke();
                    _CurLevel = InstLevel(levelPrefs[i]);
                    _CurLevelIndex = _CurLevel.curLevelIndex;
                    onAfterLoadLevel?.Invoke();
                    _CurLevel.OnLoadLevel();
                    break;
                }
            }

            //销毁上一个关卡
            if (_LastLevel != null)
            {
                if (_LastLevel.gameObject.activeSelf)
                {
                    _LastLevel.OnUnLoadLevel();
                }
                DestroyLevel(_LastLevel);
            }

            //记录当前关卡
            _LastLevel = _CurLevel;

            return _CurLevel;
        }

        Debug.LogError("levelIndex is error,levelIndex:" + levelIndex);
        return null;
    }

    LevelCtrl InstLevel(LevelCtrl ctrl)
    {
        GameObject go = GameObject.Instantiate(ctrl.gameObject);
        go.transform.SetParent(transform);
        return go.GetComponent<LevelCtrl>();
    }

    void DestroyLevel(LevelCtrl ctrl)
    {
        GameObject.Destroy(ctrl.gameObject);
    }

    /// <summary>
    /// 加载当前关卡
    /// </summary>
    public void LoadCurLevel()
    {
        LoadLevel(_CurLevelIndex);
    }
    //加载选定关卡
    public void LoadSelectLevel(int level)
    {
        for (int i = 0; i < levelPrefs.Count; ++i)
        {
            if (levelPrefs[i].curLevelIndex == level)
            {
                LoadLevel(level);
            }
        }
    }

    /// <summary>
    /// 加载下一关卡
    /// </summary>
    public void LoadNextLevel()
    {
        int nextLevelIndex = _CurLevelIndex + 1;
        for (int i = 0; i < levelPrefs.Count; ++i)
        {
            if (levelPrefs[i].curLevelIndex == nextLevelIndex)
            {
                LoadLevel(nextLevelIndex);//加载下一关
                return;
            }
        }

        //TODO 当前为加载第一个关，之后改为显示通关
        _CurLevelIndex = -1;
        LoadNextLevel();
    }

    private void OnDestroy()
    {
        levelPrefs.Clear();
        levelPrefs = null;

        _CurLevel = null;
        onBeforeLoadLevel = null;
        onAfterLoadLevel = null;
    }
}
