﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PropSelectUI : MonoBehaviour
{
    public GameObject m_strengthObj;
    public GameObject m_doubleObj;
    public GameObject m_coinObj;
    private void OnEnable()
    {
        SetOpenState();
    }
    //点击加强
    public void OnClickStrength()
    {
        BattleCtrl.instance.battleUI.SetBombStrength();
        BattleCtrl.instance.battleUI.SetCoin(-10);
        SetOpenState();
    }
    //点击double
    public void OnClickDouble()
    {
        BattleCtrl.instance.battleUI.SetBombDouble();
        BattleCtrl.instance.battleUI.SetCoin(-20);
        SetOpenState();
    }
    //点击金币
    public void OnClickCoin()
    {
        BattleCtrl.instance.battleUI.SetCoinDouble();
        BattleCtrl.instance.battleUI.SetCoin(-10);
        SetOpenState();
    }
    //开始
    public void OnClickStart()
    {
        gameObject.SetActive(false);
        Invoke("DelayHandle", 0.1f);
    }
    void DelayHandle()
    {
        BattleCtrl.instance.SelectPropState = false;
    }
    //设置open状态
    void SetOpenState()
    {
        int varCoin = LocalRecord.GetIntRecord(GlobalConfig.CoinReCordKey);
        m_strengthObj.SetActive(varCoin >= 10);
        m_doubleObj.SetActive(varCoin >= 20);
        m_coinObj.SetActive(varCoin >= 10);
    }
}
