﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using RayFire;
using DG.Tweening;

public class BombState1View : MonoBehaviour
{
    public GameObject m_normalBombObj;
    public GameObject m_strengthBombObj;
    public GameObject m_rocketBombObj;
    public Transform m_normalParent;
    public Transform m_strengthParent;
    public Transform m_rocketParent;

    private RayfireBomb m_normalRayfire;
    private RayfireBomb m_strengthRayfire;
    private RayfireBomb m_rocketRayfire;
    private GameObject m_bombEffect;
    private Vector3 m_bombPos;
    private Vector3 m_secondBombPos;
    private Sequence m_sqFirst;

    private void Awake()
    {
        m_normalRayfire = m_normalBombObj.GetComponent<RayfireBomb>();
        m_strengthRayfire = m_strengthBombObj.GetComponent<RayfireBomb>();
        m_rocketRayfire = m_rocketBombObj.GetComponent<RayfireBomb>();
    }
    //爆破动画效果
    public void PlayBombAni()
    {
        if (BattleCtrl.instance.battleUI.IsBombStrength)
        {
            m_sqFirst = DOTween.Sequence();
            m_sqFirst.Append(m_strengthParent.DOScale(Vector3.one * 0.8f, 0.5f));
            m_sqFirst.Append(m_strengthParent.DOScale(Vector3.one * 1.2f, 0.5f));
            m_sqFirst.Append(m_strengthParent.DOScale(Vector3.one * 0.25f, 0.25f));
            m_sqFirst.Append(m_strengthParent.DOScale(Vector3.one * 2.0f, 0.25f));
            m_sqFirst.AppendCallback(OverAniCB);
        }
        else if(BattleCtrl.instance.battleUI.IsBombDouble)
        {
            m_sqFirst = DOTween.Sequence();
            m_sqFirst.Append(m_rocketParent.DOScale(Vector3.one * 0.8f, 0.5f));
            m_sqFirst.Append(m_rocketParent.DOScale(Vector3.one * 1.2f, 0.5f));
            m_sqFirst.Append(m_rocketParent.DOScale(Vector3.one * 0.25f, 0.25f));
            m_sqFirst.Append(m_rocketParent.DOScale(Vector3.one * 2.0f, 0.25f));
            m_sqFirst.AppendCallback(OverAniCB);
        }
        else
        {
            m_sqFirst = DOTween.Sequence();
            m_sqFirst.Append(m_normalParent.DOScale(Vector3.one * 0.8f, 0.5f));
            m_sqFirst.Append(m_normalParent.DOScale(Vector3.one * 1.2f, 0.5f));
            m_sqFirst.Append(m_normalParent.DOScale(Vector3.one * 0.25f, 0.25f));
            m_sqFirst.Append(m_normalParent.DOScale(Vector3.one * 2.0f, 0.25f));
            m_sqFirst.AppendCallback(OverAniCB);
        }
    }
    //动画播放结束回调
    void OverAniCB()
    {
        BattleCtrl.instance.battleUI.OnClickBoomBtn();
        BattleCtrl.instance.battleUI.SetSelectUIState(true);
    }
    //开始爆破
    public void StartBomb()
    {
        if (BattleCtrl.instance.battleUI.IsBombStrength)
        {
            m_bombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
            m_bombEffect.transform.position = m_bombPos;
            GameServices.timerServices.Push(this, 1.0f, delegate
            {
                PoolManager.Instance.ReturnObjectToPool(m_bombEffect);
            });
            m_strengthRayfire.Explode(0);
            m_strengthBombObj.SetActive(false);
        }
        else if(BattleCtrl.instance.battleUI.IsBombDouble)
        {
            m_bombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombRocketEffectObj);
            m_bombEffect.transform.position = m_bombPos;
            GameServices.timerServices.Push(this, 1.0f, delegate
            {
                PoolManager.Instance.ReturnObjectToPool(m_bombEffect);
            });
            m_rocketRayfire.Explode(0);
            m_rocketBombObj.SetActive(false);
        }
        else
        {
            m_bombEffect = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.bombEffectObj);
            m_bombEffect.transform.position = m_bombPos;
            GameServices.timerServices.Push(this, 1.0f, delegate
            {
                PoolManager.Instance.ReturnObjectToPool(m_bombEffect);
            });
            m_normalRayfire.Explode(0);
            m_normalBombObj.SetActive(false);
        }
    }
    //设置模型
    public void SetBombModel()
    {
        if (BattleCtrl.instance.battleUI.IsBombStrength)
        {
            m_strengthBombObj.SetActive(true);
        }
        else if(BattleCtrl.instance.battleUI.IsBombDouble)
        {
            m_rocketBombObj.SetActive(true);
        }
        else
        {
            m_normalBombObj.SetActive(true);
        }
    }
    //设置模型位置
    public void SetBombModelPos(Vector3 pos)
    {
        if (BattleCtrl.instance.battleUI.IsBombStrength)
        {
            m_strengthBombObj.transform.position = pos;
        }
        else if(BattleCtrl.instance.battleUI.IsBombDouble)
        {
            m_rocketBombObj.transform.position = pos;
        }
        else
        {
            m_normalBombObj.transform.position = pos;
        }
        m_bombPos = pos;
    }
    //清除状态
    public void ClearState()
    {
        m_normalBombObj.SetActive(false);
        m_strengthBombObj.SetActive(false);
        m_rocketBombObj.SetActive(false);
        m_normalParent.localScale = Vector3.one;
        m_strengthParent.localScale = Vector3.one;
        m_rocketParent.transform.localScale = Vector3.one;
        m_sqFirst.Kill();
    }
}
