using System.Collections.Generic;
using UnityEngine;

public class HoppingEditorTestUI: EditorTestUI
{
    HoppingBattleController hoppingBattleController => this.m_BattleSceneEditorTest.battleController as HoppingBattleController;
    
    public TouchPad touchPad;

    protected override void Awake()
    {
        base.Awake();
        if (touchPad)
        {
            touchPad.onPointerStay = OnPointerMove;
            touchPad.onPointerDown = OnPointerDown;
            touchPad.onPointerUp = OnPointerUp;
        }
    }

    public override void Init(BattleSceneEditorTest battleSceneEditorTest)
    {
        base.Init(battleSceneEditorTest);
    }

    public override void TestShowResult(BattleResult battleResult)
    {
        base.TestShowResult(battleResult);
         
        if (Game.Instance)
            testResultText.text = $"分数：{battleResult.score}\n点击屏幕进入下一关";
        else
            testResultText.text = $"分数：{battleResult.score}\n点击屏幕重新开始";

    }

    private void OnPointerDown(int pointer, Vector3  position)
    {
       
        
    }

    private void OnPointerMove(int pointer, Vector3 position)
    {
       
        
    }
    
    private void OnPointerUp(int pointer, Vector3 position)
    {
       
        
    }

    
    void Update()
    {
       
        
    }
    
}