﻿using System.Collections;
using System.Collections.Generic;


/// <summary>
/// 游戏配置
/// </summary>
public class GameSetting
{
    List<IAudioSetting> audioSettings = new List<IAudioSetting>();
    public void AddAudioSettingListener(IAudioSetting audioSetting)
    {
        if (audioSetting != null)
            audioSettings.Add(audioSetting);

        audioSetting.SetMusic(m_BgMusic);
        audioSetting.SetSound(m_SoundEffect);
    }
    public void RemoveAudioSettingListener(IAudioSetting audioSetting)
    {
        if(audioSetting != null)
            audioSettings.Remove(audioSetting);
    }
    

    private bool m_SoundEffect = true;

	/// <summary>
	/// 音效 是否开启
	/// </summary>
	public bool soundEffect
	{
		get { return m_SoundEffect; }
		set
		{
			if (m_SoundEffect != value)
			{
				m_SoundEffect = value;

                if (audioSettings != null)
                {
                    foreach(var audio in audioSettings)
                        audio.SetSound(value);
                }
				this.Save();
			}
		}
	}

	private bool m_BgMusic = false;

	/// <summary>
	/// bmg 是否开启
	/// </summary>
	public bool bgMusic
	{
		get { return m_BgMusic; }
		set
		{
			if (m_BgMusic != value)
			{
				m_BgMusic = value;
                
                if (audioSettings != null)
                {
                    foreach (var audio in audioSettings)
                        audio.SetMusic(value);
                }
                this.Save();
			}
		}
	}

	private bool m_Vibration = true;

	/// <summary>
	/// Vibration 是否开启
	/// </summary>
	public bool vibration
	{
		get { return m_Vibration; }
		set
		{
			if (m_Vibration != value)
			{
				m_Vibration = value;
				
				this.Save();
			}
		}
	}

	
	
	private bool m_TestingMode = false;

	/// <summary>
	/// 测试模式
	/// Debug包 直接开启测试模式
	/// 发布包 白名单登录后才可以配置测试模式
	/// </summary>

	public bool testingMode
	{
		get
		{
			#if DEBUG
			return true;
			#else
			return true;
			#endif
		}
		set
		{
			if (m_TestingMode != value)
			{
				m_TestingMode = value;
				this.Save();
			}
		}
	}

	/// <summary>
	/// 载入设定
	/// </summary>
	public void Load ()
	{
		// 
		m_SoundEffect = UnityEngine.PlayerPrefs.GetInt("_GameSetting_SoundEffect_", 1) == 1;
		m_BgMusic = UnityEngine.PlayerPrefs.GetInt("_GameSetting_BGM_", 0) == 1;
		m_Vibration = UnityEngine.PlayerPrefs.GetInt("_GameSetting_Vibration_", 1) == 1;
	
		this.LoadTestingMode();
	}

   

	private void LoadTestingMode ()
	{
		m_TestingMode = true;
	}
	

	/// <summary>
	/// 存储配置
	/// </summary>
	private void Save ()
	{
		UnityEngine.PlayerPrefs.SetInt("_GameSetting_SoundEffect_", this.soundEffect ? 1 : 0);
		UnityEngine.PlayerPrefs.SetInt("_GameSetting_BGM_", this.bgMusic ? 1 : 0);
		UnityEngine.PlayerPrefs.SetInt("_GameSetting_Vibration_", this.vibration ? 1 : 0);
		UnityEngine.PlayerPrefs.Save();
	}
}
