﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class ShopPanelDisplayController : DisplayController
{
    ShopPanel m_Panel;
    public override void WillLoadDisplay()
    {
        base.WillLoadDisplay();
        if (m_Panel == null)
        {
            m_Panel = InitBattleUI();
        }
        //m_Panel.Init();
    }

    internal void GoBackToBattleUI()
    {
        parentNav.LoadDisplay<BattleUIDisplayController>();
    }

    ShopPanel InitBattleUI()
    {
        ShopPanel prefab = GameResourceManager.Load<ShopPanel>(DisplayDefine.ShopPanel);
        var panel = GameObject.Instantiate<ShopPanel>(prefab, transform);
        return panel;
    }

    public override void WillHideDisplay()
    {
        base.WillHideDisplay();

        m_Panel.FadeOut();
    }

    public override void OnDelete()
    {
        base.OnDelete();

        if(m_Panel)
        {
            Destroy(m_Panel.gameObject);
        }
        m_Panel = null;
    }
}
