﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class HoppingGameData :GameData
{
    private DieGaoGaoGameUser m_HoppingGameUser;
    public override GameUser user
    {
        get { return m_HoppingGameUser;}
        set { m_HoppingGameUser = value as DieGaoGaoGameUser; }
    }

    public HoppingGameData()
    {
        m_HoppingGameUser = new DieGaoGaoGameUser();
    }
}

public class DiegGaoGaoGame : Game
{
    public static DiegGaoGaoGame instance => _instance as DiegGaoGaoGame;

    [SerializeField]
    private HoppingDataConfig m_DataConfig;

    public override DataConfig dataConfig => m_DataConfig;

    public DieGaoGaoGameUser gameUser => this.data.user as DieGaoGaoGameUser;

    protected override GameData InitGameData()
    {

    


        HoppingGameData hoppingGameData = new HoppingGameData();
        
        HoppingLocalUserData localUserData = null;
        if (PlayerPrefs.HasKey(LocalUserDataKey))
        {
            string data = PlayerPrefs.GetString(LocalUserDataKey);
            GameDebug.Log($"读取本地数据：{data}");
            localUserData = Newtonsoft.Json.JsonConvert.DeserializeObject<HoppingLocalUserData>(data);
        }
        else
        {
            localUserData = new HoppingLocalUserData();
            localUserData.InitTestData();

            string dataStr = Newtonsoft.Json.JsonConvert.SerializeObject(localUserData);
            PlayerPrefs.SetString(LocalUserDataKey,dataStr);
        }
        GameDebug.LogError($"hopping game data init");
        hoppingGameData.user.Init(localUserData);
#if Test  
        localUserData = new HCTWLocalUserData();
        localUserData.InitTestData();
#endif
        return hoppingGameData;
    }

    public override BattleController NewBattleController()
    {
        return new GameObject("BattleController").AddComponent<HoppingBattleController>(); 
    }

    public override void OnGameResult(BattleResult result)
    {
        PersonalResultPanelData resultPanelData = new PersonalResultPanelData();
        resultPanelData.level = result.level;
        resultPanelData.win = result.win;
        resultPanelData.coin = result.score;
        resultPanelData.star = result.star;
        resultPanelData.height = result.Height;

        var resultUI = this.GetActiveScene().GetComponentInChildren<DisplayControllerNav>().LoadDisplay<ResultUIDisplayController>(null, true);
         
        if (result.win)
        { 
            Game.Instance.user.UpdateCoin(Game.Instance.user.coin + result.score);
        }
         
        Game.Instance.user.UpdateLevelStar(result.level, result.star);

        resultUI.Init(resultPanelData);
        
        //BattleEnd(result.level, result.win, result.score);
    }


    public void BattleStart(int level)
    {
        Debug.Log($"BattleStart ：{level}");

        //  TinySauce.OnGameStarted(level.ToString());
    }

    public void BattleEnd(int level, bool win, int score)
    {
        Debug.Log($"BattleEnd ：{level}");
      //  TinySauce.OnGameFinished(level.ToString(), win, score);
    }

}
