﻿using System;
using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;

public class PlayerState
{
    public const int State_Normal = 0;
    public const int State_Win = 1;
    public const int State_Lose = 2;
    public const int State_InJumpToLevel = 3;
    public const int State_InJumpToWin = 4;
    public const int State_WinDropdown = 5;
}

[EntityType(ViewEntityType.player)]
public partial class PlayerEntity : CapsuleColliderEntity
{
    [SerializeField][HideInInspector]
    private int m_PlayerId;
    public int playerId
    {
        get => m_PlayerId;
        set => m_PlayerId = value;
    }

    public override bool isTrigger => false;

    /// <summary>
    /// 分数
    /// </summary>
    private int m_Score;
    public int score => m_Score;

    /// <summary>
    /// 状态
    /// </summary>
    public int state => curAction?.ID ?? PlayerState.State_Normal;

    public string GetStateName() => state == 0 ? "Normal" : state == PlayerState.State_Win ? "Win" : "Lose";
    
    /// <summary>
    /// 动作状态机
    /// </summary>
    protected ActionFSMSystem m_ActionFSMSystem;

    /// <summary>
    /// 当前动作
    /// </summary>
    public ActionFSMState curAction => m_ActionFSMSystem?.CurrentState as ActionFSMState;

    private TranslateAnim m_TranslateAnim;
    public TranslateAnim translateAnim
    {
        get
        {
            if (m_TranslateAnim == null)
            {
                m_TranslateAnim = gameObject.AddComponent<TranslateAnim>();
            }
            return m_TranslateAnim;
        }
    }

    public HoppingBattleController hoppingBattleController => this.battleController as HoppingBattleController;

 
    private void Awake()
    {
        
    }

    private void Start()
    {
       
    }

    public void Init(HoppingDataConfig dataConfig)
    {
        Init(this.m_PlayerId, dataConfig);
    }
    public void Init(int playerId,HoppingDataConfig dataConfig)
    {
        this.m_PlayerId = playerId;
        
        m_ActionFSMSystem = ActionFSMSystem.InitPlayerActionFSM(this);
    }
    
    /// <summary>
    /// 获得分数
    /// </summary>
    /// <param name="score"></param>
    public void AddScore(int score)
    {
        m_Score += score;
        
        GameDebug.Log($"获得分数：{score}");
    }

    /// <summary>
    /// 胜利
    /// </summary>
    public void OnWin()
    {
        if (state == PlayerState.State_Normal)
        {
            //state = PlayerState.State_InJumpToLevel;
            this.m_ActionFSMSystem.InputSign(PlayerState.State_InJumpToLevel);
        }
    }
    
    
    void Update()
    {
        if (!battleController) return;
        
        m_ActionFSMSystem?.Update();
        
    }

    
}