
using UnityEditor;
using UnityEngine;

[CustomEditor(typeof(PlayerEntity))]
public class PlayerEntityInspector:Editor
{
    public override void OnInspectorGUI()
    {
        
        PlayerEntity _this = target as PlayerEntity;

        if (_this != null)
        {
            _this.playerId = EditorGUILayout.IntField("PlayerId", _this.playerId);

            base.OnInspectorGUI();

            if (Application.isPlaying)
            {
                EditorGUILayout.IntField("分数", _this.score);
                EditorGUILayout.TextField("State", _this.GetStateName());
            }  
            if (GUI.changed)
            {
                EditorUtility.SetDirty(target);
            }
        }
    }
}