using System;
using System.Timers;
using UnityEngine;

public class DataConfig:MonoBehaviour
{
    [SerializeField][HideInInspector] private int m_MaxLevel = 2;
    public int maxLevel
    {
        get => m_MaxLevel;
        set
        {
            if (m_MaxLevel != value)
            {
                m_MaxLevel = value;
                UpdatePref();
            }
        }
    }

    private void Awake()
    {
        
    }

    protected void UpdatePref()
    {
#if UNITY_EDITOR
        UnityEditor.PrefabUtility.ApplyPrefabInstance(this.gameObject, UnityEditor.InteractionMode.UserAction);
        GameDebug.Log("update data");
        /*m_Seq++;
        Invoke("CheckUpdatePref",.5f);*/
#endif
    }

#if UNITY_EDITOR
    private static int m_Seq;
    void CheckUpdatePref()
    {
    }
    
#endif
    
}