using System;
using System.Collections.Generic;
using UnityEngine;

public class MapListDisplayController : DisplayController , IMapListPanel{
 
    public BattleSceneDisplayController battleScene => GetComponentInParent<BattleSceneDisplayController>();

    public MapListPanel panel;
    MapListPanelData m_Data;
    public MapListPanelData data => m_Data;

    private MapListItem curSelectedItem;

    private const string LastRequestMapListTimeKey = "LastRequestMapListTimeKey";
    public static double lastRequestMapListTime
    {
        get
        {
             double.TryParse(PlayerPrefs.GetString(LastRequestMapListTimeKey),out double value);
             return value;
        }
        set{PlayerPrefs.SetString(LastRequestMapListTimeKey,value.ToString());}
    }


    public void Init(MapListPanelData MapListPanelData)
    {
        m_Data = MapListPanelData;
        
        if(panel != null)
            panel.Init(m_Data, this);
    }

    
    public override void WillLoadDisplay()
    {
        base.WillLoadDisplay();
        
        if (panel == null)
        {
            var pref = GameResourceManager.Load<MapListPanel>(DisplayDefine.MapListPanel);
            panel = Instantiate(pref, transform);
            //panel.layer = 5;
        }

        panel.Init(m_Data,this);
    }

    public override void WillHideDisplay()
    {
        base.WillHideDisplay();
        
        this.panel.FadeOut();
    }

    public override void OnDelete()
    {
        base.OnDelete();

        if (this.panel)
        {
            Destroy(panel.gameObject);
        }
        panel = null;
    }

    private void OnDestroy()
    {
        m_Data = null;
    }

    public void OnSelectItem(MapListItem item)
    {
        Game.Instance.user.UpdateLevel(item.level);
        Game.Instance.LoadGame(item.level);
    }

    public void OnClickGoBack()
    {
        GameDebug.Log("OnClickGoBack");
        this.parentNav.LoadDisplay<BattleUIDisplayController>();
    }
}