using System;
using System.Linq;
using UnityEngine;
using UnityEngine.UI;

public class EditorTestUI : MonoBehaviour
{
    public Text testResultText;

    public Transform startsParent;
    public GameObject starPref;

    [SerializeField]
    protected BattleWidgetInfoController m_BattleWidgetInfoController;

    protected BattleSceneEditorTest m_BattleSceneEditorTest;
    
    protected virtual void Awake()
    {
        
    }
    public virtual void Init(BattleSceneEditorTest battleSceneEditorTest)
    {
        m_BattleSceneEditorTest = battleSceneEditorTest;
        
        battleSceneEditorTest.battleController.onBattleFinish = TestShowResult;
    }

    private void Start()
    {
        if(testResultText)
            testResultText.text = "";
    }
    
    protected virtual void OnDestroy()
    {
        
    }

    public virtual void TestShowResult(BattleResult battleResult)
    {
        m_CanClick = false;
        Invoke("ActiveCanClick",1);
    }

    private bool m_CanClick;

    void ActiveCanClick()
    {
        m_CanClick = true;
    }

    public void OnClickRestart()
    {
        m_BattleSceneEditorTest.Restart();
    }
    
    public void OnClickContinue()
    {
        if(!m_CanClick)return;
        
        testResultText.text = "";

        m_BattleSceneEditorTest.Restart();

        for (int i = 0; i < startsParent.childCount; i++)
        {
            Destroy(startsParent.GetChild(i).gameObject);
        }
    }


  
}