﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CSPanelDisplayController : DisplayController
{
    csPlanel m_Panel;
    public override void WillLoadDisplay()
    {
        base.WillLoadDisplay();
        if (m_Panel == null)
        {
            m_Panel = InitBattleUI();
        }
        //m_Panel.Init();
    }

    internal void GoBackToBattleUI()
    {
        parentNav.LoadDisplay<BattleUIDisplayController>();
    }

    csPlanel InitBattleUI()
    {
        csPlanel prefab = GameResourceManager.Load<csPlanel>(DisplayDefine.csPanel);
        var panel = GameObject.Instantiate<csPlanel>(prefab, transform);
        return panel;
    }

    public override void WillHideDisplay()
    {
        base.WillHideDisplay();

        m_Panel.FadeOut();
    }

    public override void OnDelete()
    {
        base.OnDelete();

        if (m_Panel)
        {
            Destroy(m_Panel.gameObject);
        }
        m_Panel = null;
    }
}
