﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;

public class AddNumAnim : MonoBehaviour {

    public Text addNumText;

    public Color addColor = Color.green;
    public Color minusColor = Color.red;

    public float animTime = 0.2f;

    public AnimationCurve animCurve;

    public Vector2 beginPos;
    public Vector2 endPos;

    UIAnim m_UIAnim;
    UIAnim uiAnim
    {
        get
        {
            if (m_UIAnim == null)
            {
                m_UIAnim = gameObject.AddComponent<UIAnim>();
                m_UIAnim.InitCurve(animCurve);
            }
            return m_UIAnim;
        }
    }


	// Use this for initialization
	void Start () {
		
	}

    public void Show(int num)
    {
        if (num >= 0)
        {
            addNumText.text = "+" + num;

            addNumText.color = addColor;
        }
        else
        {
            addNumText.text =  num.ToString() ;

            addNumText.color = minusColor;
        }

        var textRect = addNumText.GetComponent<RectTransform>();

        textRect.anchoredPosition = beginPos;

        uiAnim.RectMove(textRect, endPos, animTime);
    }


	
	// Update is called once per frame
	void Update () {
		
	}
}
