﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;

/// <summary>
/// 视角控制器
/// 角色跟随 / 小地图移动
/// </summary>
public class BattleCameraParent : MonoBehaviour 
{
	protected bool m_BeginMapMoveEnd = false;

	public Vector3 farDir = new Vector3(-1,0,-.25f);

	protected Vector3 m_CamBeginPos;
	protected Vector3 m_CamBeginRot;

	public Camera cam;
	public bool followY { get; set; }

	protected virtual void Awake()
	{
		if (cam == null)
			cam = GetComponentInChildren<Camera>();

		m_CamBeginPos = cam.transform.localPosition;
		m_CamBeginRot = cam.transform.localRotation.eulerAngles;
	}

	protected virtual void Start()
	{
		
	}

	public void SetRolePosition (Vector3 position)
    {
        /*if (m_InGameStartMove)
        {
            m_RolePostion = position;
            return;
        }*/

		//this.transform.localPosition = position;
        this.SetTargetPos(position);
        
	}


	private Vector3 m_TargetStartPos;
	private Vector3 m_TargetPos = Vector3.zero;

	private float m_CurSmoothTime = 0f;
	
	/// <summary>
	/// 当前正在使用的曲线
	/// </summary>
	public AnimationCurve lerpCurve;
	/// <summary>
	/// 当前正在使用的时间
	/// </summary>
	/// 
	public float lerpTimeDuration = 0.2f;

	private void SetTargetPos (Vector3 targetPos)
	{
		if (!followY)
		{
			targetPos.y = transform.localPosition.y;
		}
		if ((m_TargetPos - targetPos).sqrMagnitude > 0.001f)
		{
            m_CurSmoothTime = 0;
            m_TargetStartPos = this.transform.localPosition;
			m_TargetPos = targetPos;
		}
	}


	void LerpToTargetPos ()
	{
        m_CurSmoothTime += Time.deltaTime;
		if (m_CurSmoothTime > lerpTimeDuration)
		{
			this.transform.localPosition = m_TargetPos;
		}
		else
		{
			this.transform.localPosition = m_TargetStartPos + (m_TargetPos - m_TargetStartPos) * lerpCurve.Evaluate(m_CurSmoothTime / lerpTimeDuration);
		}
	}

	void Update ()
    {
	    this.LerpToTargetPos();
    }

}
