﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.EventSystems;

public class TouchPad : MonoBehaviour,IPointerDownHandler,IPointerUpHandler
{
    public Action<int, Vector3> onPointerDown;
    public Action<int, Vector3> onPointerStay;
    public Action<int, Vector3> onPointerUp;

    private Dictionary<int, bool> m_IsPointerDown = new Dictionary<int, bool>();
    //private Dictionary<int, Vector3> m_PointerPrePos = new Dictionary<int, Vector3>();
    
    // Start is called before the first frame update
    void Start()
    {
        
    }

    private bool m_PointerDown;
    public void OnPointerDown(PointerEventData eventData)
    {
        //GameDebug.LogShowy($"OnPointerDown:{eventData.pointerId}");
        
        m_IsPointerDown[eventData.pointerId] = true;
        
        onPointerDown?.Invoke(eventData.pointerId,eventData.position);

        m_PointerDown = true;
    }

    public void OnPointerUp(PointerEventData eventData)
    {
        //GameDebug.LogShowy($"OnPointerUp:{eventData.pointerId}");
        
        m_IsPointerDown[eventData.pointerId] = false;
        
        onPointerUp?.Invoke(eventData.pointerId,eventData.position);
    }

    void Update()
    {
        if (m_PointerDown)
        {
            m_PointerDown = false;
            return;
        }
        
        foreach (var IsPointerDown in m_IsPointerDown)
        {
            if (IsPointerDown.Value)
            {
                int pointerId = IsPointerDown.Key;
                
                Vector3 curPos = Input.mousePosition;
                Vector3 prePos = Input.mousePosition;
                
                if (Application.platform == RuntimePlatform.WindowsEditor)
                {
                    curPos = Input.mousePosition;
                }
                else
                {
                    if (pointerId < Input.touchCount)
                    {
                        curPos = Input.GetTouch(pointerId).position;
                    }
                    else
                    {
                        return;
                    }
                }
                
                this.onPointerStay?.Invoke(pointerId,curPos);
                
                /*if (m_PointerPrePos.ContainsKey(pointerId))
                {
                     prePos = m_PointerPrePos[pointerId];
                     
                     this.onPointerMove?.Invoke(pointerId,curPos - prePos);
                }
                else
                {
                    if (Application.platform == RuntimePlatform.WindowsEditor)
                    {
                        m_PointerPrePos[pointerId] = m_PointerPrePos[pointerId] = Input.mousePosition;
                    }
                    else
                    {
                        m_PointerPrePos[pointerId] = Input.GetTouch(pointerId).position;
                    }

                    //m_PointerPrePos[pointerId] = prePos;
                }*/
            }
        }
    }

}
