﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

[ExecuteInEditMode]
public abstract class TextureSheetAnim : MonoBehaviour {
    
    [SerializeField]
    protected Material m_RenderMat;
    public  Material renderMat
    {
        get
        {
            if (m_RenderMat == null)
                m_RenderMat = GetRenderingMaterial();
            
            return m_RenderMat;
        }
        set
        {
            m_RenderMat = value;
        }
    }

    /// <summary>
    /// 行数
    /// </summary>
    [SerializeField]
    int m_Row;
    public int row
    {
        get { return m_Row; }
        set
        {
            if(m_Row != value)
            {
                m_Row = value;
                SetTextureScale(this.tiling);
            }
        }
    }

    /// <summary>
    /// 列数
    /// </summary>
    [SerializeField]
    int m_Col;
    public int col
    {
        get { return m_Col; }
        set
        {
            if (m_Col != value)
            {
                m_Col = value;
                SetTextureScale(this.tiling);
            }
        }
    }
    
    float tilingX => m_Col == 0? 1 : 1f / m_Col;
    float tilingY => m_Row == 0? 1 : 1f / m_Row;
    Vector2 tiling => new Vector2(tilingX, tilingY);

    public int AnimBeginIndex = 0;
    public int AnimEndIndex = 0;

    int m_CurIndex;
    public int curIndex
    {
        get { return  m_CurIndex; }
        set
        {
            if(m_CurIndex != value)
            {
                m_CurIndex = ClampIndex(value,this.AnimBeginIndex,this.AnimEndIndex);

                SetIndex(m_CurIndex);
            }
        }
    }

    public int fps;
    float timePerFrame => fps == 0? 10000 : 1f / fps;
    
    protected abstract Material GetRenderingMaterial();

#if UNITY_EDITOR
    //用于避免每次运行完游戏都修改本地的材质参数
    Vector2 originalTexOffset;
    Vector2 originalTexScale;
#endif
    // Use this for initialization
    protected virtual void  Start ()
    {
#if UNITY_EDITOR
        originalTexOffset = this.renderMat.mainTextureOffset;
        originalTexScale = this.renderMat.mainTextureScale;
#endif

        SetTextureScale(this.tiling);
        StartAnim();
    }

    protected virtual void OnDestroy()
    {
#if UNITY_EDITOR
        SetTextureScale(originalTexScale);
        SetTextureOffset(originalTexOffset);
#endif
    }

    void SetTextureScale(Vector2 tiling)
    {
        if(renderMat)
            renderMat.mainTextureScale = tiling;
    }
    void SetTextureOffset(Vector2 offset)
    {
        if (renderMat)
            renderMat.mainTextureOffset = offset;
    }
    void SetIndex(int index)
    {
        SetTextureOffset(GetOffsetWithIndex(index));
    }
    
    Vector2 GetOffsetWithIndex(int index)
    {
        float xOffset = index % m_Col * tilingX;
        float yOffset = (m_Row - index / m_Col - 1) * tilingY;

        return new Vector2(xOffset, yOffset);
    }

    public bool PlayAnim = false;

    public void StartAnim()
    {
        PlayAnim = true;
    }
    public void StopAnim()
    {
        PlayAnim = false;
    }


    int ClampIndex(int index,int min,int max)
    {
        int length = max - min;
        if (length <= 0)
            return index;

        int beginDelta = index - min;
        beginDelta %= length;

        return min + beginDelta;
    }
    

    float timer = 0;
    // Update is called once per frame
    protected virtual void Update () {

        if (!PlayAnim)
            return;

        timer += Time.deltaTime;
        if(timer > timePerFrame)
        {
            timer = 0;

            curIndex++;
            SetIndex(curIndex);
        }


	}
}
