﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;
using UnityEngine.UI;

public class SceneLoadingAnim : DisplayControllerSwitchAnimation
{
    //Animator m_Animator;
    GraphicRaycaster m_GraphicRaycaster;
    Canvas m_canvas;

    public GameObject parent;
//    public GameTips gameTips;

    UIAnim uiAnim;
    public int sortingOrder = 100;
    public float fadeInTime = 0.2f;
    public float inLoadingTime = 0.2f;
    public float fadeOutTime = 0.4f;

    public AnimationCurve fadeInCurve;
    public AnimationCurve fadeOutCurve;

    public bool useSelfAnim = true;

    void  Awake()
    {
        //m_Animator = GetComponentInChildren<Animator>();
        m_GraphicRaycaster = GetComponent<GraphicRaycaster>();
        m_canvas = GetComponent<Canvas>();

        if (useSelfAnim)
        {
            uiAnim = GetComponent<UIAnim>();
            if (uiAnim == null) uiAnim = gameObject.AddComponent<UIAnim>();
        }

        if (parent)
                parent.gameObject.SetActive(false);
        
    }


    protected override  void OnDestroy()
    {
        m_InLoadingEnd = null;
    }


    public bool showText = false;
    protected  override  void PlayShowAnim(DisplayController dc,Action onAnimEnd)
    {
        if (parent)
            parent.gameObject.SetActive(true);

        /*if(gameTips)
            gameTips.RefreshTips();*/

        PlayAnim(() =>
        {
            if (onAnimEnd != null)
                onAnimEnd();
        });
    }

    public SliderAnim sliderAnim;
    public Text inloadingText;
    public bool SelfPlaySliderAnim = true;
    private Action m_InLoadingEnd;
    protected override void PlayInLoadingAnim( Action onEnd)
    {        
        m_InLoadingEnd = onEnd;

        if (sliderAnim  && SelfPlaySliderAnim)
        {
            sliderAnim.gameObject.SetActive(true);

            //Invoke("OnLoadingAnimEnd",inLoadingTime);
            
            //if (SelfPlaySliderAnim)
            sliderAnim.PlaySlider(this.inLoadingTime,m_InLoadingEnd);
        }
        else
        {
            PlayInLoading(onEnd);
        }
    }

    protected override void PlayHideAnim(Action onAnimEnd)
    {
        Hide(() =>
        {
            if (parent)
                parent.gameObject.SetActive(false);

            if(sliderAnim)
                sliderAnim.ResetAnim();

            if (onAnimEnd != null)
                onAnimEnd();
        });
    }



    /// <summary>
    /// 播放切换场景过渡动画
    /// </summary>
    /// <param name="onFinished"></param>
    public void PlayAnim(Action onFinished)
    {
        //if (isFadingToBlack)
        //    return;

        GameDebug.Log("PlayAnim!!");
        
        if(m_canvas)
            m_canvas.sortingOrder = sortingOrder;
        
        if (m_GraphicRaycaster == null) m_GraphicRaycaster = GetComponent<GraphicRaycaster>();
        if(m_GraphicRaycaster) m_GraphicRaycaster.enabled = true;

        if (useSelfAnim)
        {
            uiAnim.InitCurve(fadeInCurve);
            uiAnim.SetImgTxtAlpha(transform.GetComponent<RectTransform>(), 0);
            uiAnim.UIAlpha(transform.GetComponent<RectTransform>(), 1, fadeInTime, onFinished, UIAnim.EaseType.Curve,
                (color, img) =>
                {
                    var sheetAnim = img.GetComponent<ImageSheetAnim>();
                    if (sheetAnim)
                        sheetAnim.renderMat.color = color;

                });
        }
        else
        {
            onFinished?.Invoke();
        }

        SetBlock(true);
    }


    void PlayInLoading(Action onEnd)
    {
       Invoke("OnInLoadingEnd",inLoadingTime);
    }

    void OnInLoadingEnd()
    {
        if (m_InLoadingEnd != null)
            m_InLoadingEnd();
    }
    
    public void Hide(Action onFinished)
    {
        //Debug.Log("Hide!!");
        //if (isFadingToBright)
        //    return;

        if(m_canvas)
            m_canvas.sortingOrder = sortingOrder;
        
        if (m_GraphicRaycaster == null) m_GraphicRaycaster = GetComponent<GraphicRaycaster>();
        if(m_GraphicRaycaster) m_GraphicRaycaster.enabled = false;

        if (useSelfAnim)
        {
            uiAnim.InitCurve(fadeOutCurve);
            uiAnim.UIAlpha(transform.GetComponent<RectTransform>(), 0, fadeOutTime, onFinished, UIAnim.EaseType.Curve,
                (color, img) =>
                {
                    var sheetAnim = img.GetComponent<ImageSheetAnim>();
                    if (sheetAnim)
                        sheetAnim.renderMat.color = color;

                });
        }
        else
        {
            onFinished?.Invoke();
        }

        SetBlock(false);
    }

    void SetBlock(bool block)
    {
        if (this)
        {
            foreach (var img in GetComponentsInChildren<Image>())
            {
                img.raycastTarget = block;
            }

            foreach (var Text in GetComponentsInChildren<Text>())
            {
                Text.raycastTarget = block;
            }
        }
    }
    
   

    float dataInitPercent = 0.4f;//数据加载的占比
    public void OnDataProgress(float progress)
    {
        GameDebug.Log("OnDataProgress:" + progress);

        if (sliderAnim)
            sliderAnim.SetSliderValue(dataInitPercent * progress);

        ///数据加载完，播放剩余进度
        if (progress >= 1 && sliderAnim != null)
            sliderAnim.PlaySlider(this.inLoadingTime,m_InLoadingEnd);
        
    }
    
    float timer = 0;
    string[] m_PointStrs = new string[4] { "",".", "..", "..." };
    int m_PointIndex = 0;
    public int LoadingTextAnimFPS = 6;
    float LoadingTextAnimTimePerFrame => LoadingTextAnimFPS == 0 ? 10000 : 1f / LoadingTextAnimFPS;

    void Update()
    {
        if (inLoading)
        {
            /*if(this.inloadingText)
            {
                timer += Time.deltaTime;
                if(timer > LoadingTextAnimTimePerFrame)
                {
                    timer = 0;

                    m_PointIndex ++;
                    m_PointIndex %= m_PointStrs.Length;

                    //Debug.Log("m_PointIndex:" + m_PointIndex);

                    inloadingText.text =  new MultiLangKey("data_loading") + m_PointStrs[m_PointIndex];
                }
            }*/
        }
        
    }


}
