﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class FloatTips : TipsBase
{

    public enum AnimType
    {
        MoveUp,//向上移动
        Stay,//不动
    }
    public AnimType type = AnimType.MoveUp;

    protected override void Awake()
    {
        base.Awake();
    }

    public override void SetContent(string content)
    {
        Init(content, true);
    }
    public void Init(string content,bool playSound)
    {
        base.SetContent(content);

        if(type == AnimType.MoveUp)
            StartCoroutine(PlaymoveUpAnim(playSound));
        else if (type == AnimType.Stay)
            StartCoroutine(PlayStayAnim(playSound));
    }

    IEnumerator PlaymoveUpAnim(bool playSound)
    {
        if(playSound)
            AudioManager.instance.PlayUISound(Audio.floatTips);
        
        const float fadeOutTime = 0.5f;
        m_UIAnim.RectMove(this.GetComponent<RectTransform>(), new Vector2(0, 200), showTime, null,UIAnim.EaseType.Curve);
        yield return new WaitForSeconds(showTime - fadeOutTime);
        m_UIAnim.UIAlpha(this.GetComponent<RectTransform>(),0, fadeOutTime, OnAnimEnd, UIAnim.EaseType.Curve);
    }
    IEnumerator PlayStayAnim(bool playSound)
    {
        if (playSound)
            AudioManager.instance.PlayUISound(Audio.floatTips);

        const float fadeOutTime = 0.5f;
        yield return new WaitForSeconds(showTime - fadeOutTime);
        m_UIAnim.UIAlpha(this.GetComponent<RectTransform>(), 0, fadeOutTime, OnAnimEnd, UIAnim.EaseType.Curve);
    }
    void OnAnimEnd()
    {
        Destroy(gameObject);
    }
}
