﻿using System;
using System.Collections;
using System.Collections.Generic;
using Unity.Collections;
using UnityEngine;

public class BattleWidgetInfoController : MonoBehaviour {


    
    // Use this for initialization
    protected virtual void Start ()
    {
        

    }


    public T ShowObject<T>( string pId,Action<bool,T> init,GameObject pref,Transform parent)where T:MonoBehaviour
    {
        if (!this) return null;

        bool isNewObj;
        var cache = widgetCache.GetCache<T>(pref.gameObject, pId, out isNewObj);
        cache.transform.SetParent(parent);
        
        var pi = cache.GetComponent<T>();

        init?.Invoke(isNewObj,pi);

        return pi;
    }

    public void HideObject<T>(string pId )where T:MonoBehaviour
    {
        if (!this) return;
        
        var dict = widgetCache.GetDict<T>();
        if (dict.ContainsKey(pId)
            && dict[pId] != null)
        {
            Destroy(dict[pId].gameObject);
            dict.Remove(pId);
        }
    }
    
    WidgetCache m_WidgetCache;
    WidgetCache widgetCache
    {
        get
        {
            if (m_WidgetCache == null) m_WidgetCache = GetComponent<WidgetCache>();
            if (m_WidgetCache == null) m_WidgetCache = gameObject.AddComponent<WidgetCache>();

            return m_WidgetCache;
        }
    }


    // Update is called once per frame
    void Update () {

    }

}
