﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;
using System.IO;
using UnityEngine.UI;

public class CommonFunctions {

    public static void ClearList(List<GameObject> _list)
    {
        if (_list != null)
        {
            for (int i = 0; i < _list.Count; i++)
            {
#if UNITY_EDITOR
                if (_list[i] != null)
                    GameObject.DestroyImmediate(_list[i].gameObject);
#endif
                if (_list[i] != null)
                    GameObject.Destroy(_list[i].gameObject);

            }
            _list.Clear();
        }
    }

    public static void ClearList<T>(List<T> _list) where T : MonoBehaviour
    {
        if (_list != null)
        {
            for (int i = 0; i < _list.Count; i++)
            {
#if UNITY_EDITOR
                if (_list[i] != null)
                    GameObject.DestroyImmediate(_list[i].gameObject);
#endif
                if (_list[i] != null)
                    GameObject.Destroy(_list[i].gameObject);
                
            }
            _list.Clear();
        }
    }
    
    /// <summary>
    /// 时间转换天时分秒显示
    /// </summary>
    /// <returns>The stamp to HM.</returns>
    /// <param name="seconds">seconds</param>
    public static string TimeToDHMS(double secondsd)
    {
        var seconds = (int)secondsd;
        var day = seconds / 86400;
        var secondsInDay = seconds % 86400;
        var hour = secondsInDay / 3600;
        var minute = (secondsInDay - hour * 3600) / 60;
        var second = secondsInDay - hour * 3600 - minute * 60;
        if (day > 0)
        {
            return string.Format("{0}d {1:D2}:{2:D2}:{3:D2}", day, hour, minute, second);
        }
        else
        {
            return string.Format("{0:D2}:{1:D2}:{2:D2}", hour, minute, second);
        }
    }
    
    public static string TimeToMS(double secondsd)
    {
        var seconds = (int)secondsd;
        var minute = seconds / 60;
        var second = seconds - minute * 60;
        return string.Format("{0:D2}:{1:D2}", minute, second);
        
    }

    public static Transform FindInChild(Transform trans, string name)
    {
        if (trans.name == name)
            return trans;
        
        foreach(Transform child in trans)
        {
            var findInChild = FindInChild(child, name);
            if (findInChild != null)
                return findInChild;
        }

        return null;
    }
    public static List<Transform> FindAllInChild(Transform trans, string name)
    {
        List<Transform> res = new List<Transform>();
           var ts = trans.GetComponentsInChildren<Transform>();
        foreach (var t in ts)
        {
            if (t.name == name)
                res.Add(t);
        }
        return res;
    }

    public static bool Vector3Equal(Vector3 a, Vector3 b,int precision)
    {
        long pow = (long)Mathf.Pow(10, precision);
        return (long)(a.x * pow) == (long)(b.x * pow)
                && (long)(a.y * pow) == (long)(b.y * pow)
                && (long)(a.z * pow) == (long)(b.z * pow);
    }

    /// <summary>
    /// 名字只显示八位
    /// </summary>
    /// <param name="name"></param>
    /// <returns></returns>
    public static string GetShowedName(string name,bool showExtend)
    {
        if (string.IsNullOrEmpty(name)) 
            return "";
        
        if (name.Length > 8)
        {
            name = name.Substring(0, 8);
            if (showExtend)
                name += "...";
        }
        return name;
    }

    public static double GetTimeStampSeconds()
    { 
        TimeSpan ts = DateTime.UtcNow - new DateTime(1970, 1, 1, 0, 0, 0, 0);
        return ts.TotalSeconds;
    }
}