﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

public abstract class  DisplayControllerSwitchAnimation : MonoBehaviour 
{
    public bool inShowing;
    public bool inHiding;
    public bool inLoading;
   
/*    Action m_OnShowEnd;
    Action m_OnInLoadingEnd;*/
    DisplayController m_CurDisplayController;
    public DisplayController curDisplayController { get { return m_CurDisplayController; } }

    protected virtual void OnDestroy()
    {
        //m_OnShowEnd = null;
        //m_OnInLoadingEnd = null;
    }

    public void ToPlayShowAnim(DisplayController controller, Action onEnd)
    {
        inShowing = true;
        m_CurDisplayController = controller;
        PlayShowAnim(controller, ()=>
        {
            inShowing = false;
            onEnd?.Invoke();
        });
    }


    public void ToPlayInLoadingAnim(Action onEnd)
    {
        inLoading = true;
        PlayInLoadingAnim(()=>
        {
            inLoading = false;
            onEnd?.Invoke();
        });
    }
    

    public void ToPlayHideAnim(Action onEnd)
    {
        inHiding = true;
        
        PlayHideAnim(()=>
            {
                inHiding = false;

                if (onEnd != null)
                    onEnd();
            }
        );
    }

    protected abstract void PlayShowAnim(DisplayController controller, Action onEnd);
    protected abstract void PlayInLoadingAnim(Action onEnd);
    protected abstract void PlayHideAnim(Action onEnd);




}
