﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;
using System;

public class UIImagePingPongAnim : ColorPingPongAnim {

    public Image m_Image;

    public bool selfStart = true;

    // Use this for initialization
    void Start()
    {
       if(m_Image == null)
            m_Image = GetComponentInChildren<Image>();

    }

    private void OnEnable()
    {
        if (selfStart)
            Play();
    }
    private void OnDisable()
    {
        Stop();
    }

    public override Action<Color> SetColorFunc()
    {
        Action<Color> p = (color) =>
        {
            if (m_Image)
                m_Image.color = color;
        };
        return p;
    }

    public override Func<Color> GetColorFunc()
    {
        Func<Color> f = () =>
        {
            if (m_Image)
                return m_Image.color;
            else
                return Color.white;
        };
        return f;
    }

}
