﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

[System.Serializable]
public struct PanAnimParameter
{
    public RectTransform trans;
    public Vector2 showBeginPos;
    public Vector2 showPos;
    public Vector2 hidePos;
    public float showAnimTime;
    public float hideAnimTime;
    public Action onShowAnimEnd;
    public Action onHideAnimEnd;
}

public class UIElementPan : MonoBehaviour {
    
    UIAnim m_UIAnim;

    [SerializeField]
    AnimationCurve m_FadeInCurve = AnimationCurve.EaseInOut(0,0,1,1);
    [SerializeField]
    AnimationCurve m_FadeOutCurve = AnimationCurve.EaseInOut(0, 0, 1, 1);

    public bool HideOnHideAnimEnd = true;

    // Use this for initialization
    void Awake ()
    {
        if (m_UIAnim == null) m_UIAnim = gameObject.AddComponent<UIAnim>();
    }

    private void Start()
    {

    }

    public float defaultShowAnimTime = 0.2f;
    public float defaultHideAnimTime = 0.2f;

    [SerializeField]
    List<PanAnimParameter> m_PanAnimParameters = new List<PanAnimParameter>();

    public void Init(PanAnimParameter panAnimParameter)
    {
        Init(new List <PanAnimParameter> { panAnimParameter });
    }
    public void Add(PanAnimParameter panAnimParameter)
    {
        m_PanAnimParameters.Add(panAnimParameter);
    }
    /// <summary>
    /// 
    /// </summary>
    /// <param name="trans">ui列表</param>
    /// <param name="showBeginPos">ui列表对应的显示动画起始位置</param>
    /// <param name="showPos">>ui列表对应的显示位置</param>
    /// <param name="hidePos">>ui列表对应的隐藏位置</param>
    public void Init(List<PanAnimParameter> panAnimParameters)
    {
        m_PanAnimParameters = panAnimParameters;
    }

    public void AddHorizontalAnim(RectTransform trans, float showBeginPos, float showPos, float hidePos, float showAnimTime, float hideAnimTime, Action onShowAnimEnd, Action onHideAniEnd)
    {
        AddHorizontalAnim(new List<RectTransform> { trans }, new List<float> { showBeginPos }, new List<float> { showPos }, new List<float> { hidePos }, showAnimTime, hideAnimTime, onShowAnimEnd, onHideAniEnd);
    }
    public void AddHorizontalAnim(List<RectTransform> trans, List<float> showBeginPos, List<float> showPos, List<float> hidePos, Action onShowAnimEnd, Action onHideAniEnd)
    {
        AddHorizontalAnim(trans, showBeginPos, showPos,hidePos,this.defaultShowAnimTime,this.defaultHideAnimTime, onShowAnimEnd, onHideAniEnd);
    }
    public void AddHorizontalAnim(List<RectTransform> trans,List<float> showBeginPos, List<float> showPos, List<float> hidePos, float showAnimTime, float hideAnimTime, Action onShowAnimEnd, Action onHideAniEnd)
    {
        for (int i=0;i<trans.Count;i++)
        {
            PanAnimParameter pan = new PanAnimParameter();
            pan.trans = trans[i];
            pan.showBeginPos = GetXPos(trans[i], showBeginPos[i]);
            pan.showPos = GetXPos(trans[i], showPos[i]);
            pan.hidePos = GetXPos(trans[i], hidePos[i]);
            pan.showAnimTime = showAnimTime;
            pan.hideAnimTime = hideAnimTime;
            pan.onShowAnimEnd = onShowAnimEnd;
            pan.onHideAnimEnd = onHideAniEnd;

            m_PanAnimParameters.Add(pan);
        }
    }

    public void AddVerticalAnim(RectTransform trans, float showBeginPos, float showPos, float hidePos, float showAnimTime, float hideAnimTime, Action onShowAnimEnd, Action onHideAniEnd)
    {
        AddVerticalAnim(new List<RectTransform> { trans }, new List<float> { showBeginPos }, new List<float> { showPos }, new List<float> { hidePos }, showAnimTime, hideAnimTime, onShowAnimEnd, onHideAniEnd);
    }

    public void AddVerticalAnim(List<RectTransform> trans, List<float> showBeginPos, List<float> showPos, List<float> hidePos, Action onShowAnimEnd, Action onHideAniEnd)
    {
        AddVerticalAnim(trans, showBeginPos, showPos, hidePos,this.defaultShowAnimTime,this.defaultHideAnimTime, onShowAnimEnd,onHideAniEnd);
    }
    public void AddVerticalAnim(List<RectTransform> trans, List<float> showBeginPos, List<float> showPos, List<float> hidePos, float showAnimTime, float hideAnimTime, Action onShowAnimEnd, Action onHideAniEnd)
    {
        for (int i = 0; i < trans.Count; i++)
        {
            PanAnimParameter pan = new PanAnimParameter();
            pan.trans = trans[i];
            pan.showBeginPos = GetYPos(trans[i], showBeginPos[i]);
            pan.showPos = GetYPos(trans[i], showPos[i]);
            pan.hidePos = GetYPos(trans[i], hidePos[i]);
            pan.showAnimTime = showAnimTime;
            pan.hideAnimTime = hideAnimTime;
            pan.onShowAnimEnd = onShowAnimEnd;
            pan.onHideAnimEnd = onHideAniEnd;

            m_PanAnimParameters.Add(pan);
        }
       
    }
    /// <summary>
    /// 播放显示动画
    /// </summary>
    public void Show()
    {
        m_UIAnim.StopAllAnim();
        m_UIAnim.InitCurve(m_FadeInCurve);

        for (int i = 0; i < m_PanAnimParameters.Count; i++)
        {
            var pan = m_PanAnimParameters[i];
            if (pan.trans)
            {
                pan.trans.gameObject.SetActive(true);
                pan.trans.anchoredPosition = pan.showBeginPos;
                m_UIAnim.RectMove(pan.trans, pan.showPos, pan.showAnimTime, () => { OnShowAnimEnd(pan); }, UIAnim.EaseType.Curve);
            }
            else
            {
                GameDebug.LogError($"pan.trans == null i:{i}");
            }
        }
    }
    
    /// <summary>
    /// 播放隐藏动画
    /// </summary>
    public void Hide()
    {
        m_UIAnim.StopAllAnim();
        m_UIAnim.InitCurve(m_FadeOutCurve);

        for (int i = 0; i < m_PanAnimParameters.Count; i++)
        {
            var pan = m_PanAnimParameters[i];
            m_UIAnim.RectMove(pan.trans, pan.hidePos, pan.hideAnimTime,()=> { this.OnHideAnimEnd(pan); }, UIAnim.EaseType.Curve);
        }
    }

    void OnShowAnimEnd(PanAnimParameter panAnimParameter)
    {
        if (panAnimParameter.onShowAnimEnd != null)
            panAnimParameter.onShowAnimEnd();
    }

    void OnHideAnimEnd(PanAnimParameter panAnimParameter)
    {
        if(HideOnHideAnimEnd)
            HideElements();

        if (panAnimParameter.onHideAnimEnd != null)
            panAnimParameter.onHideAnimEnd();
    }

    public void HideElements()
    {
        for (int i = 0; i < m_PanAnimParameters.Count; i++)
        {
            if (m_PanAnimParameters[i].trans)
            {
                m_PanAnimParameters[i].trans.anchoredPosition = m_PanAnimParameters[i].hidePos;

                if (HideOnHideAnimEnd)
                    m_PanAnimParameters[i].trans.gameObject.SetActive(false);
            }
        }
    }

    Vector2 GetXPos(RectTransform rect, float x)
    {
        var pos = rect.anchoredPosition;
        pos.x = x;
        return pos;
    }
    Vector2 GetYPos(RectTransform rect, float y)
    {
        var pos = rect.anchoredPosition;
        pos.y = y;
        return pos;
    }

    // Update is called once per frame
    void Update () {
		
	}
}
