﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;

[System.Serializable]
struct UIElementsAlpha
{
    public RectTransform ui;
    public List<float> imgAlphas;
    public List<float> txtAlphas;
    public List<float> rawAlphas;
}

public class UIElementAlpha : MonoBehaviour {

    /// <summary>
    /// 每个RectTransfom单独使用一个UIAnim
    /// </summary>
    List<UIAnim> uiAnimList = new List<UIAnim>();

    [SerializeField]
    AnimationCurve m_AnimationCurve = AnimationCurve.EaseInOut(0,0,1,1);

    public bool HideOnHideAnimEnd = true;

    // Use this for initialization
    void Awake ()
    {

    }

    private void Start()
    {

    }

    float m_ShowAnimTime = 0.2f;
    float m_HideAnimTime = 0.2f;

    List<UIElementsAlpha> m_UIElements = new List<UIElementsAlpha>();

    Action<int> m_OnShowAnimEnd;
    Action<int> m_OnHideAniEnd;

    public void Init(RectTransform trans, float showAnimTime, float hideAnimTime, Action<int> onShowAnimEnd, Action<int> onHideAniEnd)
    {
        Init(new List <RectTransform>{ trans },  showAnimTime, hideAnimTime, onShowAnimEnd, onHideAniEnd);
    }
    /// <summary>
    /// 
    /// </summary>
    /// <param name="trans">ui列表</param>
    /// <param name="showBeginPos">ui列表对应的显示动画起始位置</param>
    /// <param name="showPos">>ui列表对应的显示位置</param>
    /// <param name="hidePos">>ui列表对应的隐藏位置</param>
    public void Init(List<RectTransform> trans, float showAnimTime, float hideAnimTime, Action<int> onShowAnimEnd, Action<int> onHideAniEnd)
    {
        m_ShowAnimTime = showAnimTime;
        m_HideAnimTime = hideAnimTime;
        m_OnShowAnimEnd = onShowAnimEnd;
        m_OnHideAniEnd = onHideAniEnd;

        for(int i=0;i<trans.Count;i++)
        {
            Add(trans[i]);
        }
    }

    public void Add(RectTransform trans)
    {
        UIElementsAlpha element = new UIElementsAlpha();

        List<float> imgAlphas;
        List<float> txtAlphas;
        List<float> rawAlphas;
        UIAnim.GetImgTxtAlpha(trans, out imgAlphas, out txtAlphas, out rawAlphas);

        element.ui = trans;
        element.imgAlphas = imgAlphas;
        element.txtAlphas = txtAlphas;
        element.rawAlphas = rawAlphas;

        m_UIElements.Add(element);

        var uiAnim = this.gameObject.AddComponent<UIAnim>();
        uiAnim.InitCurve(m_AnimationCurve);
        uiAnimList.Add(uiAnim);
    }

    /// <summary>
    /// 播放显示动画
    /// </summary>
    public void Show(int index)
    {
        if (index < 0 || index >= m_UIElements.Count)
            return;
        
        var element = m_UIElements[index];
        element.ui.gameObject.SetActive(true);
        uiAnimList[index].SetImgTxtAlpha(element.ui, 0);
        uiAnimList[index].UIAlpha(element.ui, element.imgAlphas, element.txtAlphas, element.rawAlphas, m_ShowAnimTime,
            ()=> 
            {
                OnShowAnimEnd(index);
            }
            ,UIAnim.EaseType.Curve);
        
    }
    


    /// <summary>
    /// 播放隐藏动画
    /// </summary>
    public void Hide(int index)
    {
        if (index < 0 || index >= m_UIElements.Count)
            return;
        
        uiAnimList[index].UIAlpha(m_UIElements[index].ui,0, m_HideAnimTime,
            ()=> 
            {
                this.OnHideAnimEnd(index);
            }, 
            UIAnim.EaseType.Curve);
        
    }

    void OnShowAnimEnd(int index)
    {
        if (this.m_OnShowAnimEnd != null)
            m_OnShowAnimEnd(index);
    }

    void OnHideAnimEnd(int index)
    {
        if(HideOnHideAnimEnd)
            HideElements(index);

        if (this.m_OnHideAniEnd != null)
            m_OnHideAniEnd(index);
    }

    public void HideElements(int index)
    {
        if(index < m_UIElements.Count)
        {
            m_UIElements[index].ui.gameObject.SetActive(false);
        }
    }
    
    // Update is called once per frame
    void Update () {
		
	}
}
