﻿/*********************************************************************
* 版权所有 (C)2016, DYSPACE。
* 
* 文件名称： // UnionAdEvents.cs
* 内容摘要： // 该文件是 穿山甲广告
* 其它说明： // 
* 当前版本： // V0.1
* 作    者： // Will.Wang
* 创建日期： // 
* 
* 修改记录1：// 修改历史记录，包括修改日期、修改者及修改内容
*    修改日期：
*    版 本 号：
*    修 改 人：
*    修改内容： 
* 修改记录2：…
**********************************************************************/

#if ByteDanceAd
using ByteDance.Union;
using System;
using System.Collections.Generic;
using UnityEngine;

public partial class UnionAdManager
{
    private AdNative adNative;
    private RewardVideoAd rewardAd;
    private FullScreenVideoAd fullScreenVideoAd;
    private NativeAd bannerAd;
    private BUSplashAd splashAd;
    private BUExpressSplashAd expressSplashAd;
    private NativeAd feedAd;
    private NativeAd intersititialAd;

    private AndroidJavaObject mBannerAd;
    private AndroidJavaObject mIntersititialAd;
    private AndroidJavaObject activity;
    private AndroidJavaObject mNativeAdManager;
    private AndroidJavaObject mSplashAdManager;
#if UNITY_IOS
    private ExpressRewardVideoAd expressRewardAd; // for iOS
    private ExpressFullScreenVideoAd expressFullScreenVideoAd; // for iOS
    private ExpressBannerAd iExpressBannerAd; // for iOS
    private ExpressInterstitialAd iExpressInterstitialAd; // for iOS
#else
#endif

    private ExpressAd mExpressFeedad;
    private ExpressAd mExpressBannerAd;
    private ExpressAd mExpressRectangleAd;
    private ExpressAd mExpressInterstitialAd;

    private AdNative AdNative
    {
        get
        {
            if (this.adNative == null)
            {
                this.adNative = SDK.CreateAdNative();
            }
#if UNITY_ANDROID
            SDK.RequestPermissionIfNecessary();
#endif
            return this.adNative;
        }
    }

    public AndroidJavaObject GetActivity()
    {
        if (activity == null)
        {
            var unityPlayer = new AndroidJavaClass(
            "com.unity3d.player.UnityPlayer");
            activity = unityPlayer.GetStatic<AndroidJavaObject>(
           "currentActivity");
        }
        return activity;
    }


    private sealed class RewardVideoAdListener : IRewardVideoAdListener
    {
        private UnionAdManager example;

        public RewardVideoAdListener(UnionAdManager example)
        {
            this.example = example;
        }

        public void OnError(int code, string message)
        {
            Debug.LogError("OnRewardError: " + message);
        }

        public void OnRewardVideoAdLoad(RewardVideoAd ad)
        {
            Debug.Log("OnRewardVideoAdLoad");

            ad.SetRewardAdInteractionListener(
                new RewardAdInteractionListener(this.example));
            ad.SetDownloadListener(
                new AppDownloadListener(this.example));

            this.example.rewardAd = ad;
        }

        public void OnExpressRewardVideoAdLoad(ExpressRewardVideoAd ad)
        {
        }

        public void OnRewardVideoCached()
        {
            Debug.Log("OnRewardVideoCached");

            if (this.example.rewardAd != null)
            {
                this.example.rewardAd.IsDownloaded = true;
            }
        }
    }

    private sealed class ExpressRewardVideoAdListener : IRewardVideoAdListener
    {
        private UnionAdManager example;

        public ExpressRewardVideoAdListener(UnionAdManager example)
        {
            this.example = example;
        }

        public void OnError(int code, string message)
        {
            Debug.LogError("OnRewardError: " + message);
        }

        public void OnRewardVideoAdLoad(RewardVideoAd ad)
        {
            Debug.Log("OnRewardVideoAdLoad");
            ad.SetRewardAdInteractionListener(
                new RewardAdInteractionListener(this.example));
            ad.SetDownloadListener(
                new AppDownloadListener(this.example));

            this.example.rewardAd = ad;
        }

        // iOS
        public void OnExpressRewardVideoAdLoad(ExpressRewardVideoAd ad)
        {
#if UNITY_IOS
            Debug.Log("OnRewardExpressVideoAdLoad");
            ad.SetRewardAdInteractionListener(
                new RewardAdInteractionListener(this.example));
            ad.SetDownloadListener(
                new AppDownloadListener(this.example));
            this.example.expressRewardAd = ad;
#else
#endif
        }

        public void OnRewardVideoCached()
        {
            Debug.Log("OnExpressRewardVideoCached");
#if UNITY_IOS
         if (this.example.expressRewardAd != null)
            {
                this.example.expressRewardAd.IsDownloaded = true;
            }
#endif

        }
    }
    /// <summary>
    /// Full screen video ad listener.
    /// </summary>
    private sealed class FullScreenVideoAdListener : IFullScreenVideoAdListener
    {
        private UnionAdManager example;

        public FullScreenVideoAdListener(UnionAdManager example)
        {
            this.example = example;
        }

        public void OnError(int code, string message)
        {
            Debug.LogError("OnFullScreenError: " + message);
        }

        public void OnFullScreenVideoAdLoad(FullScreenVideoAd ad)
        {
            Debug.Log("OnFullScreenAdLoad");

            ad.SetFullScreenVideoAdInteractionListener(
                new FullScreenAdInteractionListener(this.example));
            ad.SetDownloadListener(
                new AppDownloadListener(this.example));

            this.example.fullScreenVideoAd = ad;
        }

        // iOS
        public void OnExpressFullScreenVideoAdLoad(ExpressFullScreenVideoAd ad)
        {
            // rewrite
        }

        public void OnFullScreenVideoCached()
        {
            Debug.Log("OnFullScreenVideoCached");
            if (this.example.fullScreenVideoAd != null)
            {
                this.example.fullScreenVideoAd.IsDownloaded = true;
            }



        }
    }

    /// <summary>
    /// Full screen video ad listener.
    /// </summary>
    private sealed class ExpressFullScreenVideoAdListener : IFullScreenVideoAdListener
    {
        private UnionAdManager example;

        public ExpressFullScreenVideoAdListener(UnionAdManager example)
        {
            this.example = example;
        }

        public void OnError(int code, string message)
        {
            Debug.LogError("OnFullScreenError: " + message);
        }

        public void OnFullScreenVideoAdLoad(FullScreenVideoAd ad)
        {
            Debug.Log("OnFullScreenAdLoad");

            ad.SetFullScreenVideoAdInteractionListener(
                new FullScreenAdInteractionListener(this.example));
            ad.SetDownloadListener(
                new AppDownloadListener(this.example));

            this.example.fullScreenVideoAd = ad;
        }

        // iOS
        public void OnExpressFullScreenVideoAdLoad(ExpressFullScreenVideoAd ad)
        {
#if UNITY_IOS
            Debug.Log("OnExpressFullScreenAdLoad");

            ad.SetFullScreenVideoAdInteractionListener(
                new FullScreenAdInteractionListener(this.example));
            ad.SetDownloadListener(
                new AppDownloadListener(this.example));

            this.example.expressFullScreenVideoAd = ad;
#else
#endif
        }

        public void OnFullScreenVideoCached()
        {
            Debug.Log("OnFullScreenVideoCached");
#if UNITY_IOS
       if (this.example.expressFullScreenVideoAd != null)
            {
                this.example.expressFullScreenVideoAd.IsDownloaded = true;
            }
#endif

        }
    }

    private sealed class ExpressAdListener : IExpressAdListener
    {
        private UnionAdManager example;
        private int type;//0:feed   1:banner  2:interstitial

        public ExpressAdListener(UnionAdManager example, int type)
        {
            this.example = example;
            this.type = type;
        }
        public void OnError(int code, string message)
        {
            Debug.LogError("onExpressAdError: " + message);
        }

        public void OnExpressAdLoad(List<ExpressAd> ads)
        {
            Debug.LogError("OnExpressAdLoad");
            IEnumerator<ExpressAd> enumerator = ads.GetEnumerator();
            if (enumerator.MoveNext())
            {
                switch (type)
                {
                    case 0:
                        this.example.mExpressFeedad = enumerator.Current;
                        this.example.mExpressFeedad.SetExpressInteractionListener(new ExpressAdInteractionListener(this.example, 0));
                        this.example.mExpressFeedad.SetDownloadListener(
                            new AppDownloadListener(this.example));
                        break;
                    case 1:
                        UnionAdManager UnionAdManager = this.example;
                        //UnityThread.PostAction(() =>
                        {
                            UnionAdManager.mExpressBannerAd = enumerator.Current;
                        }
                        //);
                        break;
                    case 2:
                        this.example.mExpressInterstitialAd = enumerator.Current;
                        break;
                }
            }
        }
#if UNITY_IOS

        public void OnExpressBannerAdLoad(ExpressBannerAd ad)
        {
            Debug.Log("OnExpressBannerAdLoad");
            ad.SetExpressInteractionListener(
                new ExpressAdInteractionListener(this.example,1));
            ad.SetDownloadListener(
                new AppDownloadListener(this.example));
            this.example.iExpressBannerAd = ad;
        }

        public void OnExpressInterstitialAdLoad(ExpressInterstitialAd ad)
        {
            Debug.Log("OnExpressInterstitialAdLoad");
            ad.SetExpressInteractionListener(
                new ExpressAdInteractionListener(this.example, 2));
            ad.SetDownloadListener(
                new AppDownloadListener(this.example));
            this.example.iExpressInterstitialAd = ad;
        }
#else
#endif
    }

    private sealed class ExpressAdInteractionListener : IExpressAdInteractionListener
    {
        private UnionAdManager example;
        int type;//0:feed   1:banner  2:interstitial

        public ExpressAdInteractionListener(UnionAdManager example, int type)
        {
            this.example = example;
            this.type = type;
        }
        public void OnAdClicked(ExpressAd ad)
        {
            Debug.LogError("express OnAdClicked,type:" + type);
        }

        public void OnAdShow(ExpressAd ad)
        {
            Debug.LogError("express OnAdShow,type:" + type);
        }

        public void OnAdViewRenderError(ExpressAd ad, int code, string message)
        {
            Debug.LogError("express OnAdViewRenderError,type:" + type);
        }

        public void OnAdViewRenderSucc(ExpressAd ad, float width, float height)
        {
            Debug.LogError("express OnAdViewRenderSucc,type:" + type);
        }
        public void OnAdClose(ExpressAd ad)
        {
            Debug.LogError("express OnAdClose,type:" + type);
        }
    }

    private sealed class ExpressAdDislikeCallback:IDislikeInteractionListener
    {
        private UnionAdManager example;
        int type;//0:feed   1:banner
        public ExpressAdDislikeCallback(UnionAdManager example, int type)
        {
            this.example = example;
            this.type = type;
        }
        public void OnCancel()
        {
            Debug.LogError("express dislike OnCancel");
        }

        public void OnRefuse()
        {
            Debug.LogError("express dislike onRefuse");
        }

        public void OnSelected(int var1, string var2)
        {
            Debug.LogError("express dislike OnSelected:" + var2);
#if UNITY_IOS
        
#else
            //释放广告资源
            switch (type)
            {
                case 0:
                    if (this.example.mExpressFeedad != null)
                    {
                        NativeAdManager.Instance().DestoryExpressAd(this.example.mExpressFeedad.handle);
                        this.example.mExpressFeedad = null;
                    }
                    break;
                case 1:
                    if (this.example.mExpressBannerAd != null)
                    {
                        NativeAdManager.Instance().DestoryExpressAd(this.example.mExpressBannerAd.handle);
                        this.example.mExpressBannerAd = null;
                    }
                    break;
            }
#endif
        }
    }

    
    private sealed class RectangleAdListener : IExpressAdListener
    {
        private UnionAdManager example;
        private int type;//0:feed   1:banner  2:interstitial

        public RectangleAdListener(UnionAdManager example, int type)
        {
            this.example = example;
            this.type = type;
        }
        public void OnError(int code, string message)
        {
            Debug.LogError("onRectangleAdError: " + message);
        }

        public void OnExpressAdLoad(List<ExpressAd> ads)
        {
            Debug.LogError("OnRectangleAdLoad");
            IEnumerator<ExpressAd> enumerator = ads.GetEnumerator();
            if (enumerator.MoveNext())
            {
                switch (type)
                {
                    case 0:
                        this.example.mExpressFeedad = enumerator.Current;
                        this.example.mExpressFeedad.SetExpressInteractionListener(new RectangleAdInteractionListener(this.example, 0));
                        this.example.mExpressFeedad.SetDownloadListener(
                            new AppDownloadListener(this.example));
                        break;
                    case 1:
                        UnionAdManager UnionAdManager = this.example;
                        //UnityThread.PostAction(() =>
                        {
                            UnionAdManager.mExpressRectangleAd = enumerator.Current;
                        }
                            //);
                        break;
                    case 2:
                        this.example.mExpressInterstitialAd = enumerator.Current;
                        break;
                }
            }
        }
#if UNITY_IOS

        public void OnExpressBannerAdLoad(ExpressBannerAd ad)
        {
            Debug.Log("OnExpressBannerAdLoad");
            ad.SetExpressInteractionListener(
                new ExpressAdInteractionListener(this.example,1));
            ad.SetDownloadListener(
                new AppDownloadListener(this.example));
            this.example.iExpressBannerAd = ad;
        }

        public void OnExpressInterstitialAdLoad(ExpressInterstitialAd ad)
        {
            Debug.Log("OnExpressInterstitialAdLoad");
            ad.SetExpressInteractionListener(
                new ExpressAdInteractionListener(this.example, 2));
            ad.SetDownloadListener(
                new AppDownloadListener(this.example));
            this.example.iExpressInterstitialAd = ad;
        }
#else
#endif
    }

    private sealed class RectangleAdInteractionListener : IExpressAdInteractionListener
    {
        private UnionAdManager example;
        int type;//0:feed   1:banner  2:interstitial

        public RectangleAdInteractionListener(UnionAdManager example, int type)
        {
            this.example = example;
            this.type = type;
        }
        public void OnAdClicked(ExpressAd ad)
        {
            Debug.LogError("Rectangle OnAdClicked,type:" + type);
        }

        public void OnAdShow(ExpressAd ad)
        {
            Debug.LogError("Rectangle OnAdShow,type:" + type);
        }

        public void OnAdViewRenderError(ExpressAd ad, int code, string message)
        {
            Debug.LogError("Rectangle OnAdViewRenderError,type:" + type);
        }

        public void OnAdViewRenderSucc(ExpressAd ad, float width, float height)
        {
            Debug.LogError("Rectangle OnAdViewRenderSucc,type:" + type);
        }
        public void OnAdClose(ExpressAd ad)
        {
            Debug.LogError("Rectangle OnAdClose,type:" + type);
        }
    }

    private sealed class RectangleAdDislikeCallback:IDislikeInteractionListener
    {
        private UnionAdManager example;
        int type;//0:feed   1:banner
        public RectangleAdDislikeCallback(UnionAdManager example, int type)
        {
            this.example = example;
            this.type = type;
        }
        public void OnCancel()
        {
            Debug.LogError("Rectangle dislike OnCancel");
        }

        public void OnRefuse()
        {
            Debug.LogError("Rectangle dislike onRefuse");
        }

        public void OnSelected(int var1, string var2)
        {
            Debug.LogError("Rectangle dislike OnSelected:" + var2);
#if UNITY_IOS
        
#else
            //释放广告资源
            switch (type)
            {
                case 0:
                    if (this.example.mExpressFeedad != null)
                    {
                        NativeAdManager.Instance().DestoryExpressAd(this.example.mExpressFeedad.handle);
                        this.example.mExpressFeedad = null;
                    }
                    break;
                case 1:
                    if (this.example.mExpressRectangleAd != null)
                    {
                        NativeAdManager.Instance().DestoryExpressAd(this.example.mExpressRectangleAd.handle);
                        this.example.mExpressRectangleAd = null;
                    }
                    break;
            }
#endif
        }
    }

    
    
    private sealed class NativeAdInteractionListener : IInteractionAdInteractionListener
    {
        private UnionAdManager example;
        int type;//0:feed   1:banner
        public NativeAdInteractionListener(UnionAdManager example, int type)
        {
            this.example = example;
        }

        public void OnAdShow()
        {
            Debug.Log("NativeAd show");
        }

        public void OnAdClicked()
        {
            Debug.Log("NativeAd click");
        }

        public void OnAdDismiss()
        {
            Debug.Log("NativeAd close");

            //释放广告资源
            switch (type)
            {
                case 0:
                    this.example.feedAd = null;
                    break;
                case 1:
                    this.example.bannerAd = null;
                    break;

            }
        }
    }
    private sealed class NativeAdListener : INativeAdListener
    {
        private UnionAdManager example;

        public NativeAdListener(UnionAdManager example)
        {
            this.example = example;
        }

        public void OnError(int code, string message)
        {
            Debug.LogError("OnNativeAdError: " + message);
        }

        public void OnNativeAdLoad(AndroidJavaObject list, NativeAd ad)
        {
#if UNITY_IOS
            if (ad.GetAdType() == AdSlotType.Banner)
            {
                this.example.bannerAd = ad;
            } else if (ad.GetAdType() == AdSlotType.InteractionAd)
            {
                this.example.intersititialAd = ad;
            }

            ad.SetNativeAdInteractionListener(
                new NativeAdInteractionListener(this.example, (int)(ad.GetAdType()))
            );
#else

            var size = list.Call<int>("size");

            if (size > 0)
            {
                this.example.mBannerAd = list.Call<AndroidJavaObject>("get", 0);
                this.example.mIntersititialAd = list.Call<AndroidJavaObject>("get", 0);
            }

#endif
            Debug.Log("OnNativeAdLoad");
        }
    }


    /// <summary>
    /// Full screen ad interaction listener.
    /// </summary>
    private sealed class FullScreenAdInteractionListener : IFullScreenVideoAdInteractionListener
    {
        private UnionAdManager example;

        public FullScreenAdInteractionListener(UnionAdManager example)
        {
            this.example = example;
        }

        public void OnAdShow()
        {
            Debug.Log("fullScreenVideoAd show");
        }

        public void OnAdVideoBarClick()
        {
            Debug.Log("fullScreenVideoAd bar click");
        }

        public void OnAdClose()
        {
            Debug.Log("fullScreenVideoAd close");
            var callback =  UnionAdManager.instance.onFullVideoClose;
            callback?.Invoke();
            UnionAdManager.instance.onFullVideoClose = null;
            
            UnionAdManager.instance.ResetFullVideoAd();
            UnionAdManager.instance.LoadFullScreenVideoAd();
            
#if UNITY_IOS
            this.example.expressFullScreenVideoAd = null;
#endif
        }

        public void OnVideoComplete()
        {
            Debug.Log("fullScreenVideoAd complete");
            var callback = UnionAdManager.instance.OnFullVideoFinish;
            callback?.Invoke();
            UnionAdManager.instance.OnFullVideoFinish = null;
            
            UnionAdManager.instance.ResetFullVideoAd();
            UnionAdManager.instance.LoadFullScreenVideoAd();
        }

        public void OnVideoError()
        {
            Debug.Log("fullScreenVideoAd OnVideoError");
            var callback =  UnionAdManager.instance.OnFullVideoError;
            callback?.Invoke("");
            UnionAdManager.instance.OnFullVideoError = null;
            
            UnionAdManager.instance.ResetFullVideoAd();
            UnionAdManager.instance.LoadFullScreenVideoAd();
        }

        public void OnSkippedVideo()
        {
            Debug.Log("fullScreenVideoAd OnSkippedVideo");
        }
    }

    private sealed class RewardAdInteractionListener : IRewardAdInteractionListener
    {
        

        private UnionAdManager example;

        public RewardAdInteractionListener(UnionAdManager example)
        {
            this.example = example;
        }

        public void OnAdShow()
        {
            Debug.Log("rewardVideoAd show");
        }

        public void OnAdVideoBarClick()
        {
            Debug.Log("rewardVideoAd bar click");
        }

        public void OnAdClose()
        {
            Debug.Log("rewardVideoAd close");

            var callback = UnionAdManager.instance.onRewardVideoClose;
            callback ?.Invoke();
            UnionAdManager.instance.onRewardVideoClose = null;
#if UNITY_IOS
            this.example.expressRewardAd = null;
#endif
            
            UnionAdManager.instance.ResetVideoAd();
            UnionAdManager.instance.LoadRewardAd();
        }
        
        public void OnVideoComplete()
        {
            Debug.Log("rewardVideoAd complete");
          
            var callback = UnionAdManager.instance.OnRewardVideoFinish;
            callback?.Invoke();
            UnionAdManager.instance.OnRewardVideoFinish = null;
            
            UnionAdManager.instance.ResetVideoAd();
            UnionAdManager.instance.LoadRewardAd();
        }

        public void OnVideoError()
        {
            Debug.LogError("rewardVideoAd error");
            var callback = UnionAdManager.instance.OnRewardVideoError;
            callback ?.Invoke();
            UnionAdManager.instance.OnRewardVideoError = null;
            
            UnionAdManager.instance.ResetVideoAd();
            UnionAdManager.instance.LoadRewardAd();
        }

        public void OnRewardVerify(
            bool rewardVerify, int rewardAmount, string rewardName)
        {
            Debug.Log("verify:" + rewardVerify + " amount:" + rewardAmount +
                " name:" + rewardName);
        }
    }

    private sealed class SplashAdListener : ISplashAdListener
    {
        private UnionAdManager example;
        private AndroidJavaObject activity;
        private AndroidJavaObject splashAdManager;
        private const int INTERACTION_TYPE_DOWNLOAD = 4;
        public SplashAdListener(UnionAdManager example)
        {
            this.example = example;
        }

        public SplashAdListener(UnionAdManager example, AndroidJavaObject activity, AndroidJavaObject splashAdManager)
        {
            this.example = example;
            this.activity = activity;
            this.splashAdManager = splashAdManager;
        }

        public void OnError(int code, string message)
        {
            Debug.Log("splash load Onerror:" + code + ":" + message);
        }

        public void OnSplashAdLoad(BUSplashAd ad)
        {
            if (ad != null)
            {
                Debug.Log("splash load Onsucc:");
#if UNITY_IOS
                ad.SetSplashInteractionListener(new SplashAdInteractionListener(this.example));
#else
                ad.SetSplashInteractionListener(new SplashAdInteractionListener(this.example, this.activity, this.splashAdManager));
                if (ad.GetInteractionType() == INTERACTION_TYPE_DOWNLOAD)
                {
                    Debug.Log("splash is download type ");
                    ad.SetDownloadListener(new AppDownloadListener(this.example));
                }
#endif
            }
#if UNITY_ANDROID
            if (ad != null && this.splashAdManager != null && this.activity != null)
            {
                this.splashAdManager.Call("showSplashAd", this.activity, ad.getCurrentSplshAd());
            }
#endif
        }


        private sealed class SplashAdInteractionListener : ISplashAdInteractionListener
        {
            private UnionAdManager example;
            private AndroidJavaObject activity;
            private AndroidJavaObject splashAdManager;
            public SplashAdInteractionListener(UnionAdManager example)
            {
                this.example = example;
            }

            public SplashAdInteractionListener(UnionAdManager example, AndroidJavaObject activity, AndroidJavaObject splashAdManager)
            {
                this.example = example;
                this.activity = activity;
                this.splashAdManager = splashAdManager;
            }

            private void DestorySplash()
            {
#if UNITY_ANDROID
                if (splashAdManager != null && this.activity != null)
                {
                    splashAdManager.Call("destorySplashView", this.activity);
                }
#else
                this.example.splashAd = null;
#endif
            }

            /// <summary>
            /// Invoke when the Ad is clicked.
            /// </summary>
            public void OnAdClicked(int type)
            {
                Debug.Log("splash Ad OnAdClicked type " + type);
#if UNITY_ANDROID
                if (type != INTERACTION_TYPE_DOWNLOAD)
                {
                    DestorySplash();
                }
#endif
            }

            /// <summary>
            /// Invoke when the Ad is shown.
            /// </summary>
            public void OnAdShow(int type)
            {
                Debug.Log("splash Ad OnAdShow");
            }

            /// <summary>
            /// Invoke when the Ad is skipped.
            /// </summary>
            public void OnAdSkip()
            {
                Debug.Log("splash Ad OnAdSkip");
                DestorySplash();
            }

            /// <summary>
            /// Invoke when the Ad time over.
            /// </summary>
            public void OnAdTimeOver()
            {
                Debug.Log("splash Ad OnAdTimeOver");
                DestorySplash();
            }

            public void OnAdClose()
            {
                DestorySplash();
            }
        }
    }

    private sealed class ExpressSplashAdListener : ISplashAdListener
    {
        private UnionAdManager example;

        public ExpressSplashAdListener(UnionAdManager example)
        {
            this.example = example;
        }

        public void OnError(int code, string message)
        {
            Debug.Log("expressSplash load Onerror:" + code + ":" + message);
        }

        public void OnSplashAdLoad(BUSplashAd ad)
        {
#if UNITY_IOS
        if (ad != null)
        {
                this.example.expressSplashAd = ad as BUExpressSplashAd;
                Debug.Log("expressSplash load Onsucc:");
                this.example.information.text = "OnLoad";
                this.example.expressSplashAd.SetSplashInteractionListener(new ExpressSplashAdInteractionListener(this.example));
        }
#endif
        }
    }




    private sealed class AppDownloadListener : IAppDownloadListener
    {
        private UnionAdManager example;

        public AppDownloadListener(UnionAdManager example)
        {
            this.example = example;
        }

        public void OnIdle()
        {
        }

        public void OnDownloadActive(
            long totalBytes, long currBytes, string fileName, string appName)
        {
            Debug.Log("下载中，点击下载区域暂停");
        }

        public void OnDownloadPaused(
            long totalBytes, long currBytes, string fileName, string appName)
        {
            Debug.Log("下载暂停，点击下载区域继续");
        }

        public void OnDownloadFailed(
            long totalBytes, long currBytes, string fileName, string appName)
        {
            Debug.LogError("下载失败，点击下载区域重新下载");
        }

        public void OnDownloadFinished(
            long totalBytes, string fileName, string appName)
        {
            Debug.Log("下载完成，点击下载区域重新下载");
        }

        public void OnInstalled(string fileName, string appName)
        {
            Debug.Log("安装完成，点击下载区域打开");
        }
    }
}
#endif