using System;
using UnityEngine;
using UnityEngine.UI;
public class MapListItemData
{
    public int level;
    public bool active;
    public int star;
}
public class MapListItem : MonoBehaviour {
    
    public Text lvText;
    public Text nameText;
    MapListItemData m_Data;
    public MapListItemData data => m_Data;

    public int level => this.m_Data.level;

    public GameObject activeGo;
    public GameObject disactiveGo;

    public GameObject[] stars;
    
    private Action<MapListItem> m_OnClick;
    
    public   void Awake()
    {
        
    }

    private void OnEnable()
    {
        transform.localPosition = Vector3.zero;
    }


    public void Init(MapListItemData itemData,Action<MapListItem> onSelect)
    {
        m_Data = itemData;
        m_OnClick = onSelect;

        lvText.text = $"{itemData.level}";
        
        activeGo.SetActive(itemData.active);
        disactiveGo.SetActive(!itemData.active);

        GameDebug.LogShowy($"star:{itemData.star}");
        
        for (int i = 0; i < stars.Length; i++)
        {
            if (i < itemData.star)
            {
                stars[i].SetActive(true);
            }
            else
            {
                stars[i].SetActive(false);
            }
        }
    }

    public void OnClick()
    {
        m_OnClick?.Invoke(this);
    }
    
    
  
    public void Release()
    {

    }

    private void OnDestroy()
    {
        m_Data = null;
    }

}