﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Data.SqlTypes;
using System.Linq;
using System.Runtime.CompilerServices;
using UnityEngine;
using UnityEngine.UI;

public interface IBattleMainUI
{
    void OnClickGoBack();
    void OnClickRestart();
    void OnClickLevelList();
    void OnClickAdSkipLevel();
    void OnClickSetting();
}

public partial class BattleMainUI : UICommon
{
    private BattleController m_BattleController;
    public BattleController battleController => m_BattleController;
    public Camera uiCamera => UICommon.s_uiCamera;

    public NumController numController;

   
    public Battle3DScene battle3dScene => battleController.battle3DScene ;


    [SerializeField]
    BattleUIWidgetInfoController m_BattleWidgetInfoController;

    private int m_Level;
    int level
    {
        get { return m_Level; }
        set
        {
            m_Level = value;
            if (levelText)
                levelText.text = $"Level{m_Level}";
        }
    }
    public Text userName;
    public Text levelText;

    public IBattleMainUI uiListener;

    public  override void Awake()
    {
        base.Awake();
   
        if (m_BattleWidgetInfoController == null)
            m_BattleWidgetInfoController = GetComponentInChildren<BattleUIWidgetInfoController>();
         
        ShowHome();
        
        if(levelText)
            levelText.text = "";
    }


    public virtual void Init(BattleController mController)
    {
        this.m_BattleController = mController;
        this.level = mController.mapId;
    }
    
    // Start is called before the first frame update
    public  override void Start()
    {
        base.Start();
        
        if(userName)
            userName.text = Game.Instance.user.name;
    }

    public GameObject[] battleObjs;
    public GameObject[] homeObjs;
    
    public void ShowBattle()
    {
        battleObjs.ForEach(e => e.SetActive(true));
        homeObjs.ForEach(e => e.SetActive(false));
    }
    
    public void ShowHome()
    {
        battleObjs.ForEach(e => e.SetActive(false));
        homeObjs.ForEach(e => e.SetActive(true));
    }
        
    public NumInfo AddNumInfo(int showNum, Transform refer, Vector3 targetUVPos,bool follow,bool moveUp,string prex = "+",Color color = new Color())
    {
        if (!m_BattleWidgetInfoController)
            return null;

        return m_BattleWidgetInfoController.AddNumInfo(showNum, refer, targetUVPos,follow,moveUp,prex,color);
    }
    
    /// <summary>
    /// 世界坐标到UI坐标的转换
    /// </summary>
    /// <param name="worldPos"></param>
    /// <param name="offset"></param>
    /// <returns></returns>
    public Vector3 WorldPosToUICameraPos(Vector3 worldPos, Vector3 offset)
    {
        if (this.battleController.battle3DScene.mainCamera == null)
            return Vector3.zero;

        var viewportPos = this.battleController.battle3DScene.mainCamera.WorldToViewportPoint(worldPos);//WorldToScreenPoint(worldPos);

        var uiPos = this.uiCamera.ViewportToWorldPoint(viewportPos) + offset;//.ScreenToWorldPoint(viewportPos)+offset;//

//        GameDebug.LogError($"viewportPos:{viewportPos}  uiPos:{uiPos}");
        
        return uiPos;
    }

    public  virtual void OnClickStart()
    {
        battleController.GameStart();
        
        this.ShowBattle();
    }
    
    public void OnClickGoBack()
    {
        uiListener?.OnClickGoBack();
    }

    public void OnClickAdSkipLevel()
    {
        uiListener?.OnClickAdSkipLevel();
    }

    public void OnClickRestart()
    {
        this.uiListener?.OnClickRestart();
    }

    public void OnClickLevelList()
    {
        this.uiListener?.OnClickLevelList();
    }
    public void OnClickSetting()
    {
        this.uiListener?.OnClickSetting();
    }

    private float m_LastUpdateTime;
    // Update is called once per frame
    protected virtual void Update()
    {
        if(Time.realtimeSinceStartup - m_LastUpdateTime >= .5f)
        {
            m_LastUpdateTime = Time.realtimeSinceStartup;
            
            BattleController bc = this.battleController;
            if (bc)
            {
/*                if (bc.mode == BattleMode.Existence)
                {
                    int timeLeft = (int)(bc.limitTime -  bc.time);
                    timeLeft = Mathf.Max(timeLeft, 0);
                    if (bc.GetMe().score >= battleController.targetScore)
                    {  
                        if (this.modeTitle)
                            this.modeTitle.text = $"{bc.GetMe().score}/{battleController.targetScore}";
                        
/*                        if (this.timeText && this.timeText.transform.parent.gameObject.activeSelf)
                            this.timeText.transform.parent.gameObject.SetActive(false);#2#
                    }
                    else
                    {
                        if (this.modeTitle)
                            this.modeTitle.text = $"{bc.GetMe().score}/{battleController.targetScore}\n" +
                                              CommonFunctions.TimeToMS(timeLeft);
                        
                        if (this.timeText)
                            this.timeText.text = timeLeft.ToString();
                    }

                }*/
             
            }
        }
    }

}
