using System;
using UnityEngine;

public abstract class ColliderEntity : ViewEntity
{
    public virtual  bool isTrigger { get; }
    public virtual Collider Collider => GetComponentInChildren<Collider>();
}


public abstract class BoxColliderEntity : ColliderEntity
{
    protected BoxCollider m_BoxCollider;
    public virtual BoxCollider boxCollider
    {
        get
        {
            if (!this)
                return null;
            
            if (m_BoxCollider == null)
                m_BoxCollider = GetComponentInChildren<BoxCollider>();

            if (m_BoxCollider == null)
            {
                m_BoxCollider = gameObject.AddComponent<BoxCollider>();
                m_BoxCollider.isTrigger = true;
            }
            
            return m_BoxCollider;
        }
    }

    protected void Awake()
    {
        if (m_BoxCollider == null)
            m_BoxCollider = GetComponent<BoxCollider>();
    }
    public void InitCol(Vector3 size, Vector3 center)
    {
        m_BoxCollider = gameObject.AddComponent<BoxCollider>();
        m_BoxCollider.size = size;
        m_BoxCollider.center = center;

        m_BoxCollider.isTrigger = isTrigger;
    }
}

public abstract class CapsuleColliderEntity : ColliderEntity
{
    protected CapsuleCollider m_CapsuleCollider;
    public CapsuleCollider capsuleCollider
    {
        get
        {
            if(m_CapsuleCollider == null)
                m_CapsuleCollider = GetComponentInChildren<CapsuleCollider>();
            
            return m_CapsuleCollider;
        }
    }
    
    protected void Awake()
    {
        if (m_CapsuleCollider == null)
            m_CapsuleCollider = GetComponentInChildren<CapsuleCollider>();
    }
    
    public void InitCol(float radius, float height)
    {
        m_CapsuleCollider = gameObject.AddComponent<CapsuleCollider>();
        m_CapsuleCollider.radius = radius;
        m_CapsuleCollider.height = height;
        m_CapsuleCollider.center = new Vector3(0,  m_CapsuleCollider.height / 2,0);

        m_CapsuleCollider.isTrigger = isTrigger;
    }
    
    

}