﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;


public class ToggleItemTab : ListToggleItem {

    public Sprite OnSprite;
    public Sprite OffSprite;
    public Color OnTxtColor = Color.white;
    public Color OffTxtColor = Color.white;
    public string OnTxtContent = "";
    public string OffTxtContent = "";

    public Color OnImgColor = Color.white;
    public Color OffImgColor = Color.white;

    public bool DisActiveBGAtOff = false;
    public Image BG;

    public bool SetToFrontWhenIsOn = false;

    public override void Awake()
    {
        base.Awake();

        OnProcessToggleValue(m_Toggle.isOn);
    }

    protected override void _OnToggleValueChange(bool isOn)
    {
        base._OnToggleValueChange(isOn);

        OnProcessToggleValue(isOn);
    }

    void OnProcessToggleValue(bool isOn)
    {
        if (m_Toggle.isOn)
        {
            SetOn();
            // Debug.LogError("isOn:" + this.gameObject.name);
        }
        else
        {
            SetOff();
        }
    }

    public void SetOn()
    {
        if (BG)
        {
            BG.sprite = OnSprite;
            BG.color = OnImgColor;
            if (DisActiveBGAtOff)
            {
                BG.gameObject.SetActive(true);
            }
        }

        if (titleText)
        {
            titleText.color = OnTxtColor;

            if (!string.IsNullOrEmpty(OnTxtContent))
            {
                titleText.text = OnTxtContent;
            }
        }

        if (SetToFrontWhenIsOn)
            transform.SetAsLastSibling();

    }

    public void SetOff()
    {
        if (BG)
        {
            BG.sprite = OffSprite;
            BG.color = OffImgColor;
            if (DisActiveBGAtOff)
            {
                BG.gameObject.SetActive(false);
            }
        }

        if (titleText)
        {
            titleText.color = OffTxtColor;

            if (!string.IsNullOrEmpty(OffTxtContent))
            {
                titleText.text = OffTxtContent;
            }
        }
    }

    public void Refresh()
    {
        //Debug.LogError("Refresh  m_Toggle.isOn:" + m_Toggle.isOn + "  name:" + name);
        OnProcessToggleValue(m_Toggle.isOn);
    }


}
